/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.ConsumerGroup;
import org.jboss.portal.registration.DuplicateRegistrationException;
import org.jboss.portal.registration.NoSuchRegistrationException;
import org.jboss.portal.registration.Registration;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationPersistenceManager;
import org.jboss.portal.registration.RegistrationStatus;
import org.jboss.portal.registration.impl.ConsumerGroupImpl;
import org.jboss.portal.registration.impl.ConsumerImpl;
import org.jboss.portal.registration.impl.RegistrationImpl;

public class RegistrationPersistenceManagerImpl
extends AbstractJBossService
implements RegistrationPersistenceManager {
    private long lastRegistrationId;
    private Map consumers = new HashMap();
    private Map groups = new HashMap();
    private Map registrations = new HashMap();

    public Consumer createConsumer(String consumerId, String consumerName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        ConsumerImpl consumer = new ConsumerImpl(consumerId, consumerName);
        consumer.setStatus(RegistrationStatus.PENDING);
        this.consumers.put(consumerId, consumer);
        return consumer;
    }

    public ConsumerGroup getConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"ConsumerGroup name", null);
        return (ConsumerGroup)this.groups.get(name);
    }

    public ConsumerGroup createConsumerGroup(String name) throws RegistrationException {
        ConsumerGroup group = this.getConsumerGroup(name);
        if (group != null) {
            throw new DuplicateRegistrationException("A ConsumerGroup named '" + name + "' has already been registered.");
        }
        group = new ConsumerGroupImpl(name);
        this.groups.put(name, group);
        return group;
    }

    public void removeConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"ConsumerGroup name", null);
        if (this.groups.remove(name) == null) {
            throw new NoSuchRegistrationException("There is no ConsumerGroup named '" + name + "'.");
        }
    }

    public void removeConsumer(String consumerId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        if (this.consumers.remove(consumerId) == null) {
            throw new RegistrationException("There is no Consumer with identity '" + consumerId + "'.");
        }
    }

    public void removeRegistration(String registrationId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration identity", null);
        RegistrationImpl registration = (RegistrationImpl)this.registrations.get(registrationId);
        if (registration == null) {
            throw new NoSuchRegistrationException("There is no Registration with id '" + registrationId + "'");
        }
        ConsumerImpl consumer = (ConsumerImpl)registration.getConsumer();
        consumer.removeRegistration(registration);
        this.registrations.remove(registrationId);
    }

    public Consumer getConsumerById(String consumerId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        return (Consumer)this.consumers.get(consumerId);
    }

    public Registration addRegistrationFor(String consumerId, Map registrationProperties) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationProperties, (String)"Registration properties");
        ConsumerImpl consumer = (ConsumerImpl)this.getConsumerById(consumerId);
        if (consumer == null) {
            throw new NoSuchRegistrationException("There is no Consumer with identity '" + consumerId + "' to add a Registration to...");
        }
        RegistrationImpl registration = new RegistrationImpl("" + this.lastRegistrationId++, consumer, RegistrationStatus.PENDING, registrationProperties);
        consumer.addRegistration(registration);
        this.registrations.put(registration.getId(), registration);
        return registration;
    }

    public Consumer addConsumerToGroupNamed(String consumerId, String groupName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)groupName, (String)"ConsumerGroup name", null);
        ConsumerGroupImpl group = (ConsumerGroupImpl)this.getConsumerGroup(groupName);
        if (group == null) {
            throw new NoSuchRegistrationException("There is no ConsumerGroup named '" + groupName + "' to add a Consumer to...");
        }
        ConsumerImpl consumer = (ConsumerImpl)this.getConsumerById(consumerId);
        if (consumer == null) {
            throw new NoSuchRegistrationException("There is no Consumer with identity '" + consumerId + "' to add to ConsumerGroup named '" + groupName + "'. Did you create it?");
        }
        group.addConsumer(consumer);
        return consumer;
    }

    public Collection getConsumers() {
        return Collections.unmodifiableCollection(this.consumers.values());
    }

    public Collection getRegistrations() {
        return Collections.unmodifiableCollection(this.registrations.values());
    }

    public Collection getConsumerGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Registration getRegistration(String registrationId) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration id", null);
        return (Registration)this.registrations.get(registrationId);
    }
}

