/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3JmxDeployment;
import org.jboss.ejb3.Ejb3ModuleMBean;
import org.jboss.ejb3.JmxDeploymentScopeImpl;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class Ejb3Module
extends ServiceMBeanSupport
implements Ejb3ModuleMBean {
    public static final String BASE_EJB3_JMX_NAME = "jboss.j2ee:service=EJB3";
    private static final Logger log = Logger.getLogger(Ejb3Module.class);
    private Ejb3JmxDeployment deployment;
    private DeploymentInfo di;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Module(DeploymentInfo di) {
        DeploymentScope deploymentScope = null;
        if (di.parent != null && (di.parent.shortName.endsWith(".ear") || di.parent.shortName.endsWith(".ear/"))) {
            HashMap hashMap = di.parent.context;
            synchronized (hashMap) {
                deploymentScope = (DeploymentScope)di.parent.context.get("EJB3_EAR_METADATA");
                if (deploymentScope == null) {
                    deploymentScope = new JmxDeploymentScopeImpl(di.parent.shortName);
                    di.parent.context.put("EJB3_EAR_METADATA", deploymentScope);
                }
            }
        }
        this.deployment = new Ejb3JmxDeployment(di, deploymentScope);
        if (deploymentScope != null) {
            deploymentScope.register(this.deployment);
        }
        this.di = di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        super.createService();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.di.ucl);
            this.deployment.create();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.di.ucl);
            this.deployment.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        super.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.di.ucl);
            this.deployment.stop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        super.stopService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.di.ucl);
            this.deployment.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        super.destroyService();
    }

    public Container getContainer(ObjectName name) {
        return this.deployment.getContainer(name);
    }

    public Map getContainers() {
        return this.deployment.getEjbContainers();
    }
}

