/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.workflow.test;

import java.util.List;
import junit.framework.TestCase;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class HelloWorldDbTest
extends TestCase {
    static JbpmConfiguration jbpmConfiguration = null;

    public void setUp() {
        jbpmConfiguration.createSchema();
    }

    public void tearDown() {
        jbpmConfiguration.dropSchema();
    }

    public void testSimplePersistence() {
        this.deployProcessDefinition();
        this.processInstanceIsCreatedWhenUserSubmitsWebappForm();
        this.theProcessInstanceContinuesWhenAnAsyncMessageIsReceived();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployProcessDefinition() {
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlString((String)"<process-definition name='hello_world'>  <start-state name='start'>    <transition to='s' />  </start-state>  <state name='s'>    <transition to='end' />  </state>  <end-state name='end' /></process-definition>");
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            jbpmContext.deployProcessDefinition(processDefinition);
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInstanceIsCreatedWhenUserSubmitsWebappForm() {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessDefinition processDefinition = graphSession.findLatestProcessDefinition("hello_world");
            ProcessInstance processInstance = new ProcessInstance(processDefinition);
            Token token = processInstance.getRootToken();
            HelloWorldDbTest.assertEquals((String)"start", (String)token.getNode().getName());
            token.signal();
            HelloWorldDbTest.assertEquals((String)"s", (String)token.getNode().getName());
            jbpmContext.save(processInstance);
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void theProcessInstanceContinuesWhenAnAsyncMessageIsReceived() {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessDefinition processDefinition = graphSession.findLatestProcessDefinition("hello_world");
            List processInstances = graphSession.findProcessInstances(processDefinition.getId());
            ProcessInstance processInstance = (ProcessInstance)processInstances.get(0);
            processInstance.signal();
            HelloWorldDbTest.assertTrue((boolean)processInstance.hasEnded());
            jbpmContext.save(processInstance);
        }
        finally {
            jbpmContext.close();
        }
    }

    static {
        jbpmConfiguration = JbpmConfiguration.parseXmlString((String)"<jbpm-configuration>  <jbpm-context>    <service name='persistence'              factory='org.jbpm.persistence.db.DbPersistenceServiceFactory' />  </jbpm-context>  <string name='resource.hibernate.cfg.xml'           value='conf/hibernate.cfg.xml' />  <string name='resource.business.calendar'           value='org/jbpm/calendar/jbpm.business.calendar.properties' />  <string name='resource.default.modules'           value='org/jbpm/graph/def/jbpm.default.modules.properties' />  <string name='resource.converter'           value='org/jbpm/db/hibernate/jbpm.converter.properties' />  <string name='resource.action.types'           value='org/jbpm/graph/action/action.types.xml' />  <string name='resource.node.types'           value='org/jbpm/graph/node/node.types.xml' />  <string name='resource.varmapping'           value='org/jbpm/context/exe/jbpm.varmapping.xml' /></jbpm-configuration>");
    }
}

