/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.impl.invocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.portal.common.invocation.Interceptor;
import org.jboss.portal.common.invocation.InterceptorStack;
import org.jboss.portal.common.invocation.InterceptorStackFactory;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.server.impl.invocation.JBossInterceptorStack;

public class JBossInterceptorStackFactory
extends AbstractJBossService
implements InterceptorStackFactory {
    protected List interceptorNames = null;
    protected List dynamicInterceptorNames = new ArrayList();
    protected InterceptorStack stack = JBossInterceptorStack.EMPTY_STACK;

    public List getInterceptorNames() {
        return this.interceptorNames;
    }

    public void setInterceptorNames(List interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public List getDynamicInterceptorNames() {
        return Collections.unmodifiableList(this.dynamicInterceptorNames);
    }

    public InterceptorStack getInterceptorStack() {
        return this.stack;
    }

    public void addInterceptor(ObjectName name) throws Exception {
        this.dynamicInterceptorNames.add(name);
    }

    public void removeInterceptor(ObjectName name) throws Exception {
        this.interceptorNames.remove(name);
    }

    public void startService() throws Exception {
        this.rebuild();
    }

    public void rebuild() throws Exception {
        ArrayList names = new ArrayList();
        if (this.interceptorNames != null) {
            names.addAll(this.interceptorNames);
        }
        names.addAll(this.dynamicInterceptorNames);
        this.log.debug((Object)("Building interceptor stack " + this.getName()));
        Interceptor[] interceptors = new Interceptor[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            ObjectName name = (ObjectName)names.get(i);
            this.log.debug((Object)("Adding interceptor " + name + " to the stack"));
            interceptors[i] = (Interceptor)this.server.getAttribute(name, "ManagedResource");
        }
        this.stack = new JBossInterceptorStack(interceptors);
    }

    public void stopService() {
        this.stack = JBossInterceptorStack.EMPTY_STACK;
    }
}

