/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.listener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.server.aspects.server.SignOutInterceptor;
import org.jboss.portal.web.RequestDispatchCallback;
import org.jboss.portal.web.ServletContainer;

public class SessionListener
implements HttpSessionListener {
    private static final SignOutInterceptor.Invalidation invalidator = new SignOutInterceptor.Invalidation();
    private Logger log = Logger.getLogger(SessionListener.class);
    private static final String KEY = "org.jboss.portal.session.contexts";

    public void sessionCreated(HttpSessionEvent arg0) {
    }

    public void sessionDestroyed(HttpSessionEvent arg0) {
        Set contexts = (Set)arg0.getSession().getAttribute(KEY);
        if (contexts != null) {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            ObjectName objectName = null;
            ServletContainer servletContainer = null;
            try {
                objectName = new ObjectName("portal:service=ServletContainerFactory");
                servletContainer = (ServletContainer)server.getAttribute(objectName, "ServletContainer");
            }
            catch (Exception e1) {
                this.log.error((Object)"Error while destroying portlet webapp sessions");
            }
            for (String dispatchContextName : contexts) {
                ServletContext dispatchContext = arg0.getSession().getServletContext().getContext(dispatchContextName);
                if (dispatchContext == null) continue;
                try {
                    servletContainer.include(dispatchContext, (HttpServletRequest)new TestHttpServletRequest(arg0.getSession()), (HttpServletResponse)new TestHttpServletResponse(), (RequestDispatchCallback)invalidator, null);
                }
                catch (Exception e) {
                    this.log.error((Object)"An error occured when trying to invalidate the sessions");
                }
            }
        }
    }

    private static class TestHttpServletResponse
    implements HttpServletResponse {
        private StringWriter writer;

        public void addCookie(Cookie cookie) {
        }

        public boolean containsHeader(String string) {
            return false;
        }

        public String encodeURL(String string) {
            return null;
        }

        public String encodeRedirectURL(String string) {
            return null;
        }

        public String encodeUrl(String string) {
            return null;
        }

        public String encodeRedirectUrl(String string) {
            return null;
        }

        public void sendError(int i, String string) throws IOException {
        }

        public void sendError(int i) throws IOException {
        }

        public void sendRedirect(String string) throws IOException {
        }

        public void setDateHeader(String string, long l) {
        }

        public void addDateHeader(String string, long l) {
        }

        public void setHeader(String string, String string1) {
        }

        public void addHeader(String string, String string1) {
        }

        public void setIntHeader(String string, int i) {
        }

        public void addIntHeader(String string, int i) {
        }

        public void setStatus(int i) {
        }

        public void setStatus(int i, String string) {
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            this.writer = new StringWriter();
            return new PrintWriter(this.writer);
        }

        public String getResult() {
            return this.writer.toString();
        }

        public void setCharacterEncoding(String string) {
        }

        public void setContentLength(int i) {
        }

        public void setContentType(String string) {
        }

        public void setBufferSize(int i) {
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() throws IOException {
        }

        public void resetBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void setLocale(Locale locale) {
        }

        public Locale getLocale() {
            return null;
        }

        public String getResponseMarkup() {
            return null;
        }
    }

    private static class TestHttpServletRequest
    implements HttpServletRequest {
        private Map attributes = new HashMap();
        private HttpSession session;

        public TestHttpServletRequest(HttpSession session) {
            this.session = session;
        }

        public String getAuthType() {
            return null;
        }

        public Cookie[] getCookies() {
            return new Cookie[0];
        }

        public long getDateHeader(String string) {
            return 0L;
        }

        public String getHeader(String string) {
            return null;
        }

        public Enumeration getHeaders(String string) {
            return null;
        }

        public Enumeration getHeaderNames() {
            return null;
        }

        public int getIntHeader(String string) {
            return 0;
        }

        public String getMethod() {
            return "GET";
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public boolean isUserInRole(String string) {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession(boolean b) {
            return this.session;
        }

        public HttpSession getSession() {
            return null;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public Object getAttribute(String key) {
            return this.attributes.get(key);
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getParameter(String string) {
            return null;
        }

        public Enumeration getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String string) {
            return new String[0];
        }

        public Map getParameterMap() {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public void setAttribute(String key, Object value) {
            this.attributes.put(key, value);
        }

        public void removeAttribute(String key) {
            this.attributes.remove(key);
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public boolean isSecure() {
            return false;
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return null;
        }

        public String getRealPath(String string) {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public String getLocalName() {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }
    }
}

