/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.service;

import java.util.List;
import javax.management.ObjectName;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.portal.core.identity.cache.CachedLDAPRoleModuleWrapper;
import org.jboss.portal.core.identity.cache.CachedLDAPUserModuleWrapper;
import org.jboss.portal.core.identity.cache.CachedUserProfileModuleWrapper;
import org.jboss.portal.core.identity.cache.IdentityCacheService;
import org.jboss.portal.core.identity.service.SimpleServiceJNDIBinder;
import org.jboss.portal.identity.DelegatingUserProfileModuleImpl;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.IdentityContextImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.IdentityServiceController;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.ServiceJNDIBinder;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.boot.IdentityServiceLoader;
import org.jboss.portal.identity.event.IdentityEvent;
import org.jboss.portal.identity.event.IdentityEventBroadcaster;
import org.jboss.portal.identity.ldap.LDAPRoleModule;
import org.jboss.portal.identity.ldap.LDAPUserModule;
import org.jboss.portal.identity.ldap.LDAPUserProfileModule;
import org.jboss.portal.identity.metadata.config.ModuleMetaData;
import org.jboss.portal.identity.metadata.service.IdentityServicesMetaData;
import org.jboss.portal.identity.metadata.service.ModuleServiceMetaData;
import org.jboss.portal.identity.service.IdentityConfigurationService;
import org.jboss.portal.identity.service.UserProfileModuleService;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.jems.as.system.JBossServiceModelMBean;

public class IdentityServiceControllerImpl
extends AbstractJBossService
implements IdentityServiceController {
    private static final Logger log = Logger.getLogger(IdentityServiceControllerImpl.class);
    private String jndiName;
    protected JNDI.Binding jndiBinding;
    private IdentityContext identityContext;
    private boolean registerMBeans = true;
    private String configFile;
    private String defaultConfigFile;
    private IdentityEventBroadcaster identityEventBroadcaster;
    private boolean ldapIdentityCache = true;
    protected Kernel kernel;

    protected void startService() throws Exception {
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
        try {
            BasicBootstrap bootstrap = new BasicBootstrap();
            bootstrap.run();
            this.kernel = bootstrap.getKernel();
        }
        catch (Exception e) {
            throw new IdentityException((Throwable)e);
        }
        IdentityServicesMetaData servicesMetaData = new IdentityServicesMetaData(this.defaultConfigFile, this.configFile);
        this.identityContext = this.bootstrapIdentityContext();
        IdentityEventBroadcaster broadcaster = this.identityEventBroadcaster;
        if (broadcaster == null) {
            broadcaster = new IdentityEventBroadcaster(){

                public void fireEvent(IdentityEvent event) {
                }
            };
        }
        try {
            this.identityContext.register((Object)broadcaster, "IdentityEventBroadcaster");
        }
        catch (Throwable throwable) {
            throw new IdentityException("Unable to install IdentityEventBroadcaster", throwable);
        }
        try {
            IdentityConfigurationService configuration = servicesMetaData.getConfigurationService();
            configuration.setIdentityContext(this.identityContext);
            configuration.start();
            IdentityServiceLoader serviceLoader = new IdentityServiceLoader(this.identityContext, this.kernel, this.registerMBeans){

                protected void registerMBean(String serviceName, Object serviceObject) throws Exception {
                    JBossServiceModelMBean mbean = new JBossServiceModelMBean(serviceObject);
                    IdentityServiceControllerImpl.this.getServer().registerMBean(mbean, new ObjectName(serviceName));
                }

                protected void unregisterMBean(String serviceName) throws Exception {
                    ObjectName on = new ObjectName(serviceName);
                    if (IdentityServiceControllerImpl.this.getServer().isRegistered(on)) {
                        IdentityServiceControllerImpl.this.getServer().unregisterMBean(on);
                    }
                }

                protected ServiceJNDIBinder getServiceJNDIBinder() throws Exception {
                    return new SimpleServiceJNDIBinder();
                }
            };
            serviceLoader.bootstrapDatasource(servicesMetaData.getDatasourceServices().getDatasourcesList());
            serviceLoader.bootstrapModules(servicesMetaData.getModuleServices().getModulesList());
            UserModule userModule = (UserModule)this.identityContext.getObject("User");
            RoleModule roleModule = (RoleModule)this.identityContext.getObject("Role");
            UserProfileModule userProfileModule = (UserProfileModule)this.identityContext.getObject("UserProfile");
            if (this.isLdapIdentityCache()) {
                JBossServiceModelMBean mbean;
                ObjectName on;
                ModuleMetaData module;
                ModuleServiceMetaData moduleService;
                String serviceName;
                SimpleServiceJNDIBinder binder = new SimpleServiceJNDIBinder();
                IdentityCacheService cacheService = new IdentityCacheService();
                binder.bind("java:portal/IdentityCacheService", cacheService);
                List modules = servicesMetaData.getModuleServices().getModulesList();
                if (userModule instanceof LDAPUserModule) {
                    LDAPUserModule ldapUserModule = (LDAPUserModule)userModule;
                    this.identityContext.unregister("User");
                    binder.unbind(ldapUserModule.getJNDIName());
                    serviceName = null;
                    for (Object moduleData : modules) {
                        moduleService = (ModuleServiceMetaData)moduleData;
                        module = moduleService.getModuleData();
                        if (!module.getType().equals(ldapUserModule.getModuleType())) continue;
                        serviceName = module.getServiceName();
                        break;
                    }
                    if (serviceName != null) {
                        on = new ObjectName(serviceName);
                        if (this.getServer().isRegistered(on)) {
                            this.getServer().unregisterMBean(on);
                        }
                    }
                    CachedLDAPUserModuleWrapper userModuleWrapper = new CachedLDAPUserModuleWrapper((LDAPUserModule)userModule, cacheService);
                    this.identityContext.register((Object)userModuleWrapper, ldapUserModule.getModuleType());
                    binder.bind(ldapUserModule.getJNDIName(), (Object)userModuleWrapper);
                    if (serviceName != null) {
                        mbean = new JBossServiceModelMBean((Object)userModuleWrapper);
                        this.getServer().registerMBean(mbean, new ObjectName(serviceName));
                    }
                }
                if (roleModule instanceof LDAPRoleModule) {
                    LDAPRoleModule ldapRoleModule = (LDAPRoleModule)roleModule;
                    this.identityContext.unregister("Role");
                    binder.unbind(ldapRoleModule.getJNDIName());
                    serviceName = null;
                    for (Object moduleData : modules) {
                        moduleService = (ModuleServiceMetaData)moduleData;
                        module = moduleService.getModuleData();
                        if (!module.getType().equals(ldapRoleModule.getModuleType())) continue;
                        serviceName = module.getServiceName();
                        break;
                    }
                    if (serviceName != null) {
                        on = new ObjectName(serviceName);
                        if (this.getServer().isRegistered(on)) {
                            this.getServer().unregisterMBean(on);
                        }
                    }
                    CachedLDAPRoleModuleWrapper roleModuleWrapper = new CachedLDAPRoleModuleWrapper((LDAPRoleModule)roleModule, cacheService);
                    this.identityContext.register((Object)roleModuleWrapper, ldapRoleModule.getModuleType());
                    binder.bind(ldapRoleModule.getJNDIName(), (Object)roleModuleWrapper);
                    if (serviceName != null) {
                        mbean = new JBossServiceModelMBean((Object)roleModuleWrapper);
                        this.getServer().registerMBean(mbean, new ObjectName(serviceName));
                    }
                }
                if (userProfileModule instanceof LDAPUserProfileModule || userProfileModule instanceof DelegatingUserProfileModuleImpl) {
                    UserProfileModuleService profileModuleService = (UserProfileModuleService)userProfileModule;
                    this.identityContext.unregister("UserProfile");
                    binder.unbind(profileModuleService.getJNDIName());
                    serviceName = null;
                    for (Object moduleData : modules) {
                        moduleService = (ModuleServiceMetaData)moduleData;
                        module = moduleService.getModuleData();
                        if (!module.getType().equals(profileModuleService.getModuleType())) continue;
                        serviceName = module.getServiceName();
                        break;
                    }
                    if (serviceName != null) {
                        on = new ObjectName(serviceName);
                        if (this.getServer().isRegistered(on)) {
                            this.getServer().unregisterMBean(on);
                        }
                    }
                    CachedUserProfileModuleWrapper userProfileModuleWrapper = new CachedUserProfileModuleWrapper(userProfileModule, cacheService);
                    this.identityContext.register((Object)userProfileModuleWrapper, profileModuleService.getModuleType());
                    binder.bind(profileModuleService.getJNDIName(), userProfileModuleWrapper);
                    if (serviceName != null) {
                        mbean = new JBossServiceModelMBean((Object)userProfileModuleWrapper);
                        this.getServer().registerMBean(mbean, new ObjectName(serviceName));
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new IdentityException("Cannot initiate identity modules: ", e);
        }
    }

    protected void stopService() throws Exception {
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }

    private IdentityContext bootstrapIdentityContext() throws Exception {
        try {
            AbstractBeanMetaData contextBMD = new AbstractBeanMetaData("portal:identity=IdentityContext", IdentityContextImpl.class.getName());
            KernelControllerContext identityKernelContext = this.kernel.getController().install((BeanMetaData)contextBMD);
            return (IdentityContext)identityKernelContext.getTarget();
        }
        catch (Throwable throwable) {
            throw new IdentityException("Unable to install IdentityContext", throwable);
        }
    }

    public IdentityContext getIdentityContext() {
        return this.identityContext;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getDefaultConfigFile() {
        return this.defaultConfigFile;
    }

    public void setDefaultConfigFile(String defaultConfigFile) {
        this.defaultConfigFile = defaultConfigFile;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public JNDI.Binding getJndiBinding() {
        return this.jndiBinding;
    }

    public void setJndiBinding(JNDI.Binding jndiBinding) {
        this.jndiBinding = jndiBinding;
    }

    public boolean isRegisterMBeans() {
        return this.registerMBeans;
    }

    public void setRegisterMBeans(boolean registerMBeans) {
        this.registerMBeans = registerMBeans;
    }

    public IdentityEventBroadcaster getIdentityEventBroadcaster() {
        return this.identityEventBroadcaster;
    }

    public void setIdentityEventBroadcaster(IdentityEventBroadcaster identityEventBroadcaster) {
        this.identityEventBroadcaster = identityEventBroadcaster;
    }

    public boolean isLdapIdentityCache() {
        return this.ldapIdentityCache;
    }

    public void setLdapIdentityCache(boolean ldapIdentityCache) {
        this.ldapIdentityCache = ldapIdentityCache;
    }
}

