/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.api.node;

import java.util.Map;
import org.jboss.portal.api.node.PortalNodeURL;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.server.request.URLContext;

public class AbstractPortalNodeURL
implements PortalNodeURL {
    protected PortalObjectId id;
    protected ControllerContext controllerContext;
    protected Map<String, String[]> parameters;
    protected Boolean wantSecure;
    protected Boolean wantAuthenticated;
    protected boolean relative;
    protected URLContext urlContext;

    public AbstractPortalNodeURL(PortalObjectId id, ControllerContext controllerContext) {
        this.id = id;
        this.controllerContext = controllerContext;
        this.relative = true;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        if (this.parameters == null) {
            this.parameters = new ParameterMap();
        }
        this.parameters.put(name, values);
    }

    public void setAuthenticated(Boolean authenticated) {
        this.wantAuthenticated = authenticated;
        this.urlContext = null;
    }

    public void setSecure(Boolean secure) {
        this.wantSecure = secure;
        this.urlContext = null;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    protected URLContext getURLContext() {
        if (this.urlContext == null) {
            URLContext tmp = this.controllerContext.getServerInvocation().getServerContext().getURLContext();
            if (this.wantSecure != null) {
                tmp = this.wantSecure != false ? tmp.asSecured() : tmp.asNonSecured();
            }
            if (this.wantAuthenticated != null) {
                tmp = this.wantAuthenticated != false ? tmp.asAuthenticated() : tmp.asNonAuthenticated();
            }
            this.urlContext = tmp;
        }
        return this.urlContext;
    }
}

