/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.content.portlet;

import java.util.ResourceBundle;
import org.jboss.portal.Mode;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.i18n.ResourceBundleFactory;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.i18n.SimpleResourceBundleFactory;
import org.jboss.portal.common.util.EmptyResourceBundle;
import org.jboss.portal.core.impl.model.content.InternalContentProvider;
import org.jboss.portal.core.impl.model.content.portlet.PortletContent;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.content.spi.handler.ContentHandler;
import org.jboss.portal.core.model.content.spi.handler.ContentState;
import org.jboss.portal.core.model.content.spi.portlet.ContentPortlet;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.content.ContentRendererContext;
import org.jboss.portal.identity.User;

public class InternalPortletContentProvider
extends InternalContentProvider
implements ContentHandler {
    private InstanceContainer instanceContainer;
    private CustomizationManager customizationManager;
    private ResourceBundleManager bundleManager;
    private LocalizedString displayName;
    private LocalizedString description;

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public CustomizationManager getCustomizationManager() {
        return this.customizationManager;
    }

    public void setCustomizationManager(CustomizationManager customizationManager) {
        this.customizationManager = customizationManager;
    }

    public void start() throws Exception {
        SimpleResourceBundleFactory factory = new SimpleResourceBundleFactory("conf/bundles/PortletContent", Thread.currentThread().getContextClassLoader());
        this.bundleManager = new ResourceBundleManager((ResourceBundle)EmptyResourceBundle.INSTANCE, (ResourceBundleFactory)factory);
        super.start();
    }

    public void stop() {
        super.stop();
    }

    protected ContentProvider createProvider() {
        return new ContentProvider(){

            public ContentType getContentType() {
                return InternalPortletContentProvider.this.getRegisteredContentType();
            }

            public LocalizedString getDisplayName() {
                return null;
            }

            public LocalizedString getDescription() {
                return null;
            }

            public ContentHandler getHandler() {
                return InternalPortletContentProvider.this;
            }

            public ContentPortlet getPortletInfo() {
                return new ContentPortlet(){

                    public String getPortletName(Mode mode) {
                        if (EDIT_CONTENT_MODE.equals((Object)mode)) {
                            return "PortletContentEditorInstance";
                        }
                        return null;
                    }
                };
            }
        };
    }

    public Content newContent(String contextId, ContentState state) {
        return new PortletContent(this, contextId, state);
    }

    public void contentDestroyed(String contextId, ContentState state) {
        InstanceDefinition instance;
        String instanceRef = state.getURI();
        if (instanceRef != null && (instance = this.instanceContainer.getDefinition(instanceRef)) != null) {
            instance.destroyCustomization(contextId);
        }
    }

    public void contentCreated(String contextId, ContentState state) {
    }

    protected Instance getPortletInstance(ContentRendererContext rendererContext) {
        Window window = rendererContext.getWindow();
        User user = rendererContext.getUser();
        return this.customizationManager.getInstance(window, user);
    }
}

