/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.metadata.portlet;

import java.util.ArrayList;
import org.jboss.portal.core.metadata.portlet.ElementMetaData;
import org.jboss.portal.core.metadata.portlet.MarkupAttribute;
import org.jboss.portal.core.metadata.portlet.MarkupElement;

public class NamedMetaElementMetaData
extends ElementMetaData {
    private String nameAttribute;
    private String contentAttribute;

    public NamedMetaElementMetaData(String nameAttribute, String contentAttribute) {
        if (nameAttribute == null) {
            throw new IllegalArgumentException("'name' attribute of meta element must NOT be null. http-equiv meta elements are not currently supported.");
        }
        if (contentAttribute == null) {
            throw new IllegalArgumentException("Content attribute required for meta element: " + nameAttribute);
        }
        this.nameAttribute = nameAttribute;
        this.contentAttribute = contentAttribute;
    }

    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public String getContentAttribute() {
        return this.contentAttribute;
    }

    public MarkupElement buildElement() {
        ArrayList<MarkupAttribute> attributes = new ArrayList<MarkupAttribute>(3);
        if (this.nameAttribute != null && this.nameAttribute.length() > 0) {
            attributes.add(new MarkupAttribute("name", this.nameAttribute, MarkupAttribute.Type.NAME));
        }
        if (this.contentAttribute != null && this.contentAttribute.length() > 0) {
            attributes.add(new MarkupAttribute("content", this.contentAttribute, MarkupAttribute.Type.CDATA));
        }
        return new MarkupElement("meta", null, false, attributes.toArray(new MarkupAttribute[attributes.size()]));
    }
}

