/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.core.admin.ui.PreferencesBean;
import org.jboss.portal.faces.el.PropertyValue;
import org.jboss.portal.faces.el.dynamic.DynamicBean;
import org.jboss.portal.portlet.info.PreferenceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceBean
implements Comparable,
DynamicBean {
    private String name;
    private boolean readOnly;
    private LocalizedString displayName;
    private LocalizedString description;
    private List<String> value;
    private String line;
    PreferencesBean container;
    private boolean stale;

    public PreferenceBean(PreferenceInfo prefInfo, List<String> value) {
        this.name = prefInfo.getKey();
        this.readOnly = Boolean.TRUE.equals(prefInfo.isReadOnly());
        this.displayName = prefInfo.getDisplayName();
        this.description = prefInfo.getDescription();
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public LocalizedString getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(LocalizedString displayName) {
        this.displayName = displayName;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedString description) {
        this.description = description;
    }

    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public boolean isStale() {
        return this.stale;
    }

    public List<String> getIndices() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.value != null) {
            for (int i = 0; i < this.value.size(); ++i) {
                list.add("index_" + i);
            }
        }
        return list;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public void select() {
        if (this.container == null) {
            throw new IllegalStateException("Not attached to a container");
        }
        this.container.selectedIndex = this.container.entries.indexOf(this);
    }

    public void deleteLine(ActionEvent event) {
        String s = event.getComponent().getId();
        int index = Integer.parseInt(s.substring(4));
        this.value.remove(index);
        this.stale = true;
    }

    public void appendLine() {
        this.value.add(this.line);
        this.stale = true;
        this.line = null;
    }

    public Class getType(Object propertyName) throws IllegalArgumentException {
        String s;
        if (propertyName instanceof String && (s = (String)propertyName).startsWith("index_")) {
            return String.class;
        }
        return null;
    }

    public PropertyValue getValue(Object propertyName) throws IllegalArgumentException {
        String s;
        if (propertyName instanceof String && (s = (String)propertyName).startsWith("index_")) {
            int index = Integer.parseInt(s.substring(6));
            return new PropertyValue((Object)this.value.get(index));
        }
        return null;
    }

    public boolean setValue(Object propertyName, Object value) throws IllegalArgumentException {
        String s;
        if (propertyName instanceof String && (s = (String)propertyName).startsWith("index_")) {
            int index = Integer.parseInt(s.substring(6));
            this.value.set(index, (String)value);
            this.stale = true;
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        PreferenceBean that = (PreferenceBean)o;
        return this.name.compareTo(that.name);
    }
}

