/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;

public class JvmRouteFilter
implements Filter {
    protected AbstractJBossManager manager_;
    protected static Logger log_ = Logger.getLogger(JvmRouteFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (log_.isDebugEnabled()) {
            ServletContext sc = filterConfig.getServletContext();
            Enumeration names = sc.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = sc.getAttribute(name);
                log_.debug((Object)("name=" + name + ", value.className: [" + value.getClass().getName() + "] value.toString: [" + value.toString() + "]"));
            }
        }
        this.manager_ = (AbstractJBossManager)filterConfig.getServletContext().getAttribute("AbstractJBossManager");
        if (this.manager_ == null) {
            throw new RuntimeException("JvmRouteFilter.init(): No AbstractJBossManager found for clustering support.");
        }
        if (log_.isDebugEnabled()) {
            log_.debug((Object)"JvmRouteFilter.init(): initializing JvmRouteFilter");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new RuntimeException("JvmRouteFilter.doFilter(): Not a http request and response type.");
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            String jvmRoute = this.manager_.getJvmRoute();
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("doFilter(): check if need to re-route based on JvmRoute. Session id: " + sessionId + " jvmRoute: " + jvmRoute));
            }
            if (jvmRoute == null) {
                throw new RuntimeException("JvmRouteFilter.doFilter(): Tomcat JvmRoute is null. Need to assign a value in Tomcat server.xml for load balancing.");
            }
            if (req.isRequestedSessionIdFromURL()) {
                log_.error((Object)"JvmRouteFilter.doFilter(): Can't handle clustering where session id is from URL. Will skip.");
            } else {
                this.handleJvmRoute(sessionId, jvmRoute, res);
            }
        }
        chain.doFilter(request, response);
    }

    protected void handleJvmRoute(String sessionId, String jvmRoute, HttpServletResponse response) {
        String requestedJvmRoute = null;
        int ind = sessionId.indexOf(".");
        if (ind > 0) {
            requestedJvmRoute = sessionId.substring(sessionId.indexOf(".") + 1, sessionId.length());
        }
        String sid = sessionId;
        if (requestedJvmRoute == null) {
            sid = sessionId + "." + jvmRoute;
            this.manager_.setNewSessionCookie(sid, response);
        } else {
            int index;
            if (requestedJvmRoute.equals(jvmRoute)) {
                return;
            }
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("handleJvmRoute(): We have detected a failover with differen jvmRoute. old one: " + requestedJvmRoute + " new one: " + jvmRoute + ". Will reset the session id."));
            }
            if ((index = sessionId.indexOf(".")) <= 0) {
                throw new RuntimeException("JvmRouteFilter.handleJvmRoute(): session id doesn't JvmRoute.");
            }
            String base = sessionId.substring(0, sessionId.indexOf("."));
            sid = base + "." + jvmRoute;
            this.manager_.setNewSessionCookie(sid, response);
            Session catalinaSession = null;
            try {
                catalinaSession = this.manager_.findSession(sessionId);
                if (catalinaSession != null) {
                    catalinaSession.setId(sid);
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("handleJvmRoute(): changed catalina session to= [" + sid + "] old one= [" + sessionId + "]"));
                    }
                }
            }
            catch (IOException e) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("handleJvmRoute(): manager_.findSession() unable to find session= [" + sessionId + "]"), (Throwable)e);
                }
                throw new NestedRuntimeException("JvmRouteFilter.handleJvmRoute(): cannot find session [" + sessionId + "]", (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.manager_ = null;
    }
}

