/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.ExceptionHandler;
import org.jboss.portletbridge.application.PortletWindowState;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;

public class SeamExceptionHandlerImpl
implements ExceptionHandler {
    protected static final Log log = LogFactory.getLog(SeamExceptionHandlerImpl.class);
    Map windowMessageMap;
    List messageList;

    public void processActionException(FacesContext context, PortletWindowState windowState, Exception e) throws BridgeException {
        log.error((Object)"Error processing action lifecycle", (Throwable)e);
        windowState.reset();
        this.handleViewSetup(context, windowState, e);
        windowState.setViewId(context.getViewRoot().getViewId());
    }

    public void processRenderException(FacesContext context, PortletWindowState windowState, Exception e) throws BridgeException {
        log.error((Object)"Error processing render lifecycle", (Throwable)e);
        this.handleViewSetup(context, windowState, e);
    }

    public void handleViewSetup(FacesContext context, PortletWindowState windowState, Exception e) {
        windowState.saveBeans(context);
        windowState.saveMessages(context);
        this.windowMessageMap = new HashMap();
        this.messageList = new ArrayList();
        String viewId = windowState.getViewId();
        if (null == context.getViewRoot() && null != viewId) {
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            UIViewRoot viewRoot = viewHandler.createView(context, viewId);
            context.setViewRoot(viewRoot);
        } else if (viewId != null) {
            viewId = windowState.getViewId();
            context.getViewRoot().setViewId(viewId);
        }
        this.handleException(context, e);
        this.windowMessageMap.put("", this.messageList);
        windowState.setMessages(this.windowMessageMap);
        windowState.restoreMessages(context);
        windowState.setViewRoot(context.getViewRoot());
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(FacesContext facesContext, Exception e) throws BridgeException {
        Manager manager = Contexts.isEventContextActive() ? (Manager)Contexts.getEventContext().get(Manager.class) : null;
        String conversationId = manager == null ? null : manager.getCurrentConversationId();
        FacesLifecycle.beginExceptionRecovery((ExternalContext)facesContext.getExternalContext());
        if (conversationId == null) {
            Manager.instance().initializeTemporaryConversation();
        } else {
            ConversationPropagation.instance().setConversationId(conversationId);
            Manager.instance().restoreConversation();
        }
        try {
            this.messageList.add(new FacesMessage("An Internal error has occured.", ""));
            this.rollbackTransactionIfNecessary();
            Exceptions.instance().handle(e);
        }
        catch (Exception ehe) {
            try {
                throw new BridgeException((Throwable)ehe);
            }
            catch (BridgeException e1) {
                this.messageList.add(new FacesMessage("Unable to process with Seam exception handler", ""));
                log.error((Object)"throwing new BridgeException was unsuccessfull");
                e1.printStackTrace();
            }
        }
        finally {
            try {
                FacesLifecycle.endRequest((ExternalContext)facesContext.getExternalContext());
                log.debug((Object)"done running exception handlers");
            }
            catch (Exception ere) {
                log.error((Object)"could not destroy contexts", (Throwable)ere);
            }
        }
    }

    protected void rollbackTransactionIfNecessary() {
        try {
            UserTransaction transaction = Transaction.instance();
            if (transaction.isActiveOrMarkedRollback() || transaction.isRolledBack()) {
                log.debug((Object)"killing transaction");
                transaction.rollback();
            }
        }
        catch (Exception te) {
            log.error((Object)"could not roll back transaction", (Throwable)te);
        }
    }
}

