/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.workspace;

import org.apache.commons.lang.StringUtils;

public enum WorkspaceType {
    PUBLIC("glyphicons glyphicons-unlock", "success", true),
    PUBLIC_INVITATION(PUBLIC, false),
    PRIVATE("glyphicons glyphicons-lock", "warning", true),
    INVITATION(PRIVATE, false);

    private final String id = this.name();
    private final String key;
    private final String icon;
    private final String color;
    private final boolean allowedInvitationRequests;

    private WorkspaceType(String icon, String color, boolean allowedInvitationRequests) {
        this.key = "WORKSPACE_TYPE_" + StringUtils.upperCase((String)this.name());
        this.icon = icon;
        this.color = color;
        this.allowedInvitationRequests = allowedInvitationRequests;
    }

    private WorkspaceType(WorkspaceType primaryType, boolean allowedInvitationRequests) {
        this.key = primaryType.key;
        this.icon = primaryType.icon;
        this.color = primaryType.color;
        this.allowedInvitationRequests = allowedInvitationRequests;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isAllowedInvitationRequests() {
        return this.allowedInvitationRequests;
    }
}

