/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeleteTModel;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class DeleteTModelFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$DeleteTModelFunction == null ? (class$org$apache$juddi$function$DeleteTModelFunction = DeleteTModelFunction.class$("org.apache.juddi.function.DeleteTModelFunction")) : class$org$apache$juddi$function$DeleteTModelFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$DeleteTModelFunction;

    public DeleteTModelFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        DeleteTModel request = (DeleteTModel)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector tModelKeyVector = request.getTModelKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            String tModelKey;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (i = 0; i < tModelKeyVector.size(); ++i) {
                tModelKey = (String)tModelKeyVector.elementAt(i);
                if (tModelKey == null || tModelKey.length() == 0 || !dataStore.isValidTModelKey(tModelKey)) {
                    throw new InvalidKeyPassedException("delete_tModel: tModelKey=" + tModelKey);
                }
                if (!dataStore.isTModelPublisher(tModelKey, publisherID)) {
                    throw new UserMismatchException("delete_tModel: userID=" + publisherID + ", " + "tModelKey=" + tModelKey);
                }
                dataStore.markTModelAsDeleted(tModelKey);
            }
            for (i = 0; i < tModelKeyVector.size(); ++i) {
                tModelKey = (String)tModelKeyVector.elementAt(i);
                dataStore.deleteTModel(tModelKey);
                log.info((Object)("Publisher '" + publisherID + "' deleted TModel with key: " + tModelKey));
            }
            dataStore.commit();
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)umex.getMessage());
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        Result result = new Result(0);
        result.setErrCode(Result.lookupErrCode(0));
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(result);
        return dispRpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            DeleteTModel request = new DeleteTModel();
            DispositionReport response = (DispositionReport)new DeleteTModelFunction(reg).execute(request);
            System.out.println("errno: " + response.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

