/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.api;

import javax.servlet.http.HttpSession;
import org.jboss.portal.api.PortalRuntimeContext;
import org.jboss.portal.api.navstate.NavigationalStateContext;
import org.jboss.portal.api.session.PortalSession;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.impl.api.navstate.NavigationalStateContextImpl;
import org.jboss.portal.core.impl.api.node.PortalNodeURLFactory;
import org.jboss.portal.core.impl.api.session.PortalSessionImpl;
import org.jboss.portal.identity.User;

public class PortalRuntimeContextImpl
implements PortalRuntimeContext {
    private NavigationalStateContextImpl navigationalStateContext;
    private PortalNodeURLFactory urlFactory;
    private PortalSession session;
    private String userId;

    public PortalRuntimeContextImpl(HttpSession session) {
        this.session = new PortalSessionImpl(session);
    }

    public PortalRuntimeContextImpl(HttpSession session, String userId) {
        this.session = new PortalSessionImpl(session);
        this.userId = userId;
    }

    public PortalRuntimeContextImpl(ControllerContext controllerContext) {
        this.navigationalStateContext = new NavigationalStateContextImpl(controllerContext.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE));
        this.session = new PortalSessionImpl(controllerContext.getServerInvocation().getServerContext().getClientRequest().getSession());
        this.urlFactory = new PortalNodeURLFactory(controllerContext);
        User user = controllerContext.getUser();
        if (user != null) {
            this.userId = user.getId().toString();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public PortalSession getSession() {
        return this.session;
    }

    public NavigationalStateContext getNavigationalStateContext() {
        return this.navigationalStateContext;
    }

    public PortalNodeURLFactory getURLFactory() {
        return this.urlFactory;
    }
}

