/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.instance;

import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceCustomization;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.StateEvent;
import org.jboss.portal.portlet.spi.InstanceContext;
import org.jboss.portal.portlet.state.AccessMode;

public class InstanceContextImpl
implements InstanceContext {
    protected final Instance instance;
    protected AccessMode accessMode;
    protected PortletContext clonedContext;
    protected PortletContext modifiedContext;

    public InstanceContextImpl(Instance instance, AccessMode accessMode) {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        this.instance = instance;
        this.accessMode = accessMode;
    }

    public String getId() {
        if (this.instance instanceof InstanceDefinition) {
            return this.instance.getId();
        }
        InstanceCustomization cust = (InstanceCustomization)this.instance;
        InstanceDefinition def = cust.getDefinition();
        return def.getId() + "." + cust.getId();
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void onStateEvent(StateEvent event) {
        StateEvent.Type type = event.getType();
        if (StateEvent.Type.PORTLET_CLONED_EVENT.equals((Object)type)) {
            this.clonedContext = event.getPortletContext();
        } else if (StateEvent.Type.PORTLET_MODIFIED_EVENT.equals((Object)type)) {
            this.modifiedContext = event.getPortletContext();
        }
    }
}

