/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.query;

import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.repository.query.AbstractLdapRepositoryQuery;
import org.springframework.ldap.repository.query.LdapQueryCreator;
import org.springframework.ldap.repository.query.LdapQueryMethod;

public class PartTreeLdapRepositoryQuery
extends AbstractLdapRepositoryQuery {
    private final PartTree partTree;
    private final Parameters<?, ?> parameters;
    private final ObjectDirectoryMapper objectDirectoryMapper;

    public PartTreeLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> clazz, LdapOperations ldapOperations) {
        super(queryMethod, clazz, ldapOperations);
        this.partTree = new PartTree(queryMethod.getName(), clazz);
        this.parameters = queryMethod.getParameters();
        this.objectDirectoryMapper = ldapOperations.getObjectDirectoryMapper();
    }

    @Override
    protected LdapQuery createQuery(Object[] actualParameters) {
        LdapQueryCreator queryCreator = new LdapQueryCreator(this.partTree, this.parameters, this.getClazz(), this.objectDirectoryMapper, actualParameters);
        return (LdapQuery)queryCreator.createQuery();
    }
}

