/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.search.impl.lucene;

import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.jboss.portal.search.Query;
import org.jboss.portal.search.impl.AbstractFederatedSearcher;
import org.jboss.portal.search.impl.lucene.LuceneQuery;
import org.jboss.portal.search.result.ResultSet;
import org.jboss.portal.search.result.impl.SimpleResult;

public abstract class LuceneFederatedSearcher
extends AbstractFederatedSearcher {
    private String id;
    private String indexPath;

    public LuceneFederatedSearcher(String id, String indexPath) {
        this.id = id;
        this.indexPath = indexPath;
    }

    public ResultSet search(Query query) {
        ResultSet result = new ResultSet(this);
        try {
            IndexSearcher searcher = new IndexSearcher(this.indexPath);
            Hits hits = searcher.search(((LuceneQuery)query).getLuceneQuery());
            for (int i = 0; i < hits.length(); ++i) {
                result.add(new SimpleResult(this.id, hits.doc(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

