/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller;

import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portal.common.invocation.AbstractInvocationContext;
import org.jboss.portal.common.invocation.InterceptorStack;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.servlet.BufferingRequestWrapper;
import org.jboss.portal.common.servlet.BufferingResponseWrapper;
import org.jboss.portal.core.controller.Controller;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerRequestDispatcher;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.model.portal.navstate.PortalObjectNavigationalStateContext;
import org.jboss.portal.identity.User;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portal.server.ServerURL;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.server.request.URLFormat;
import org.jboss.portal.web.ServletContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerContext
extends AbstractInvocationContext {
    public static final int CLASSIC_TYPE = 0;
    public static final int AJAX_TYPE = 1;
    private final ServerInvocation serverInvocation;
    private final Controller controller;
    private final int type;
    private int depth;

    public ControllerContext(ServerInvocation serverInvocation, Controller controller) {
        if (serverInvocation == null) {
            throw new IllegalArgumentException();
        }
        if (controller == null) {
            throw new IllegalArgumentException();
        }
        this.serverInvocation = serverInvocation;
        this.controller = controller;
        this.depth = 0;
        HttpServletRequest req = serverInvocation.getServerContext().getClientRequest();
        String value = req.getHeader("ajax");
        this.type = "true".equalsIgnoreCase(value) ? 1 : 0;
        this.addResolver(ControllerCommand.REQUEST_SCOPE, serverInvocation.getContext());
        this.addResolver(ControllerCommand.SESSION_SCOPE, serverInvocation.getContext());
        this.addResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, new PortalObjectNavigationalStateContext(serverInvocation.getContext().getAttributeResolver(ControllerCommand.PRINCIPAL_SCOPE)));
        this.addResolver(ControllerCommand.PRINCIPAL_SCOPE, serverInvocation.getContext());
    }

    public ServletContainer getServletContainer() {
        return this.serverInvocation.getRequest().getServer().getServletContainer();
    }

    public ControllerResponse execute(ControllerCommand command) throws ControllerException, InvocationException {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        command.createContext(this);
        int oldDepth = this.depth++;
        try {
            InterceptorStack commandStack = this.controller.getStackFactory().getInterceptorStack();
            ControllerResponse controllerResponse = (ControllerResponse)command.invoke(commandStack);
            return controllerResponse;
        }
        catch (Exception e) {
            ControllerCommand.rethrow(e);
            throw new Error("Should not happen");
        }
        finally {
            this.depth = oldDepth;
            command.destroyContext();
        }
    }

    public int getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    public String renderURL(ControllerCommand cmd, URLContext urlContext, URLFormat urlFormat) {
        ServerURL serverURL = this.controller.getURLFactory().doMapping(this, this.serverInvocation, cmd);
        if (serverURL == null) {
            return null;
        }
        return this.serverInvocation.getResponse().renderURL(serverURL, urlContext, urlFormat);
    }

    public ServerInvocation getServerInvocation() {
        return this.serverInvocation;
    }

    public Controller getController() {
        return this.controller;
    }

    public User getUser() {
        return (User)this.getAttribute(ServerInvocation.PRINCIPAL_SCOPE, "user");
    }

    public Map<String, String> getUserProfile() {
        return (Map)this.getAttribute(ServerInvocation.PRINCIPAL_SCOPE, "profile");
    }

    public ControllerRequestDispatcher getRequestDispatcher(String contextPath, String path) {
        ServerInvocationContext serverContext = this.serverInvocation.getServerContext();
        ServletContext servletContext = serverContext.getClientRequest().getSession().getServletContext().getContext(contextPath);
        RequestDispatcher rd = servletContext.getRequestDispatcher(path);
        if (rd != null) {
            BufferingRequestWrapper bufferReq = new BufferingRequestWrapper(serverContext.getClientRequest(), contextPath, this.serverInvocation.getRequest().getLocales());
            BufferingResponseWrapper bufferResp = new BufferingResponseWrapper(serverContext.getClientResponse());
            return new ControllerRequestDispatcher(rd, bufferReq, bufferResp);
        }
        return null;
    }
}

