/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.metadata.portlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jboss.portal.common.io.UndeclaredIOException;
import org.jboss.portal.common.io.WriterCharWriter;
import org.jboss.portal.common.text.AbstractCharEncoder;
import org.jboss.portal.common.text.CharEncoder;
import org.jboss.portal.common.text.CharWriter;
import org.jboss.portal.common.text.EncodingException;
import org.jboss.portal.common.text.FastURLEncoder;

public class MarkupAttribute {
    private final String name;
    private final String value;
    final Type type;

    public MarkupAttribute(String name, String value, Type type) {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String toString() {
        return this.toString("");
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getEncodedValue() {
        StringWriter tmp = new StringWriter(32);
        this.encodeValueTo(null, tmp);
        return tmp.toString();
    }

    public String getEncodedValue(String contextPath) {
        StringWriter writer = new StringWriter(64);
        this.encodeValueTo(contextPath, writer);
        return writer.toString();
    }

    private void encodeValueTo(String contextPath, Writer writer) {
        if (contextPath != null && this.type == Type.URI && this.value.startsWith("/")) {
            Type.URI.encode(contextPath, writer);
        }
        this.type.encode(this.getValue(), writer);
    }

    public Type getType() {
        return this.type;
    }

    public void write(String urlPrefix, Writer writer) throws UndeclaredIOException {
        if (urlPrefix == null) {
            throw new IllegalArgumentException("No context path provided");
        }
        if (writer == null) {
            throw new IllegalArgumentException("No writer provided");
        }
        try {
            writer.write(this.name);
            writer.write("=\"");
            this.encodeValueTo(urlPrefix, writer);
            writer.write(34);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public String toString(String contextPath) {
        StringWriter buffer = new StringWriter(128);
        this.write(contextPath, buffer);
        return buffer.toString();
    }

    public static abstract class Type {
        public static final Type CDATA = new CDATAType();
        public static final Type NAME = new CDATAType();
        public static final Type CONTENT_TYPE = new CDATAType();
        private static final char[] SLASH_ARRAY = "/".toCharArray();
        public static final Type URI = new CDATAType(){
            final CharEncoder encoder = new AbstractCharEncoder(){

                protected void safeEncode(char c, CharWriter writer) throws EncodingException {
                    if (c == '/') {
                        writer.append(SLASH_ARRAY);
                    } else {
                        FastURLEncoder.getUTF8Instance().encode(c, writer);
                    }
                }

                protected void safeEncode(char[] chars, int off, int len, CharWriter writer) throws EncodingException {
                    int to = off + len;
                    for (int current = off; current < to; ++current) {
                        if (chars[current] == '/') {
                            writer.append(SLASH_ARRAY);
                            continue;
                        }
                        writer.append(chars[current]);
                    }
                }
            };

            public void encode(String string, Writer writer) {
                this.encoder.encode((CharSequence)string, (CharWriter)new WriterCharWriter(writer));
            }
        };
        public static final Type LINK_TYPES = new CDATAType();
        public static final Type TEXT = new CDATAType();
        public static final Type MEDIA_DESC = new CDATAType();
        public static final Type HREF = new CDATAType();

        public abstract void encode(String var1, Writer var2) throws UndeclaredIOException;

        private static class CDATAType
        extends Type {
            private CDATAType() {
            }

            public void encode(String string, Writer writer) {
                try {
                    writer.write(string);
                }
                catch (IOException e) {
                    throw new UndeclaredIOException(e);
                }
            }
        }
    }
}

