/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.control.portal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.core.controller.AccessDeniedException;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerRequestDispatcher;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.response.ErrorResponse;
import org.jboss.portal.core.controller.command.response.SecurityErrorResponse;
import org.jboss.portal.core.controller.command.response.UnavailableResourceResponse;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.control.portal.PortalControlContext;
import org.jboss.portal.core.model.portal.control.portal.PortalControlPolicy;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PageService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.page.PageResult;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.page.WindowResult;

public class DefaultPortalControlPolicy
implements PortalControlPolicy {
    private static final Logger log = Logger.getLogger(DefaultPortalControlPolicy.class);
    private static final Map errorTypeMapping = new HashMap();
    private PortalObjectContainer portalObjectContainer;

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public void doControl(PortalControlContext controlContext) {
        ControllerContext controllerCtx;
        ControllerRequestDispatcher rd;
        String resourceURI;
        String policyValue;
        PortalObject object;
        ControllerResponse response = controlContext.getResponse();
        String policyKey = null;
        Throwable cause = null;
        String message = null;
        if (response instanceof ErrorResponse) {
            ErrorResponse error = (ErrorResponse)response;
            cause = error.getCause();
            message = error.getMessage();
            if (response instanceof SecurityErrorResponse) {
                SecurityErrorResponse ser = (SecurityErrorResponse)response;
                if (ser.getStatus() == 0) {
                    policyKey = "control.portal.access_denied";
                }
            } else {
                policyKey = error.isInternal() ? "control.portal.internal_error" : "control.portal.error";
            }
        } else if (response instanceof UnavailableResourceResponse) {
            UnavailableResourceResponse unavailable = (UnavailableResourceResponse)response;
            String string = policyKey = unavailable.isLocated() ? "control.portal.unavailable" : "control.portal.not_found";
        }
        if (cause != null) {
            if (cause instanceof AccessDeniedException) {
                log.debug((Object)"Rendering portlet window  produced an error", cause);
            } else {
                log.error((Object)"Rendering portlet window  produced an error", cause);
            }
        }
        if (policyKey != null && (object = this.portalObjectContainer.getObject(controlContext.getPortalId())) != null && (policyValue = object.getProperty(policyKey)) != null && "jsp".equals(policyValue) && (resourceURI = object.getProperty("control.portal.resource_uri")) != null && (rd = (controllerCtx = controlContext.getControllerContext()).getRequestDispatcher("/portal-core", resourceURI)) != null) {
            String errorType = (String)errorTypeMapping.get(policyKey);
            rd.setAttribute("org.jboss.portal.control.ERROR_TYPE", errorType);
            rd.setAttribute("org.jboss.portal.control.CAUSE", cause);
            rd.setAttribute("org.jboss.portal.control.MESSAGE", message);
            rd.include();
            PageService ps = controlContext.getControllerContext().getController().getPageService();
            LayoutService ls = ps.getLayoutService();
            PortalLayout layout = ls.getLayout("generic", true);
            HashMap<String, String> pageProperties = new HashMap<String, String>();
            pageProperties.put("theme.renderSetId", "divRenderer");
            pageProperties.put("theme.id", "renewal");
            PageResult result = new PageResult("BILTO", pageProperties);
            HashMap<String, String> windowProps = new HashMap<String, String>();
            windowProps.put("theme.windowRendererId", "emptyRenderer");
            windowProps.put("theme.decorationRendererId", "emptyRenderer");
            windowProps.put("theme.portletRendererId", "emptyRenderer");
            WindowResult res = new WindowResult("", rd.getMarkup(), Collections.EMPTY_MAP, windowProps, null, WindowState.MAXIMIZED, Mode.VIEW);
            WindowContext blah = new WindowContext("BILTO", "maximized", "0", res);
            result.addWindowContext(blah);
            controlContext.setResponse(new PageRendition(layout, null, result, ps));
        }
    }

    static {
        errorTypeMapping.put("control.portal.access_denied", "ACCESS_DENIED");
        errorTypeMapping.put("control.portal.error", "ERROR");
        errorTypeMapping.put("control.portal.internal_error", "INTERNAL_ERROR");
        errorTypeMapping.put("control.portal.unavailable", "UNAVAILABLE");
        errorTypeMapping.put("control.portal.not_found", "NOT_FOUND");
    }
}

