/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget;

import java.util.concurrent.TimeUnit;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import org.jboss.logging.Logger;
import org.jboss.portal.widget.WidgetProvider;

public abstract class AbstractWidgetPortlet
extends GenericPortlet {
    private static final Logger log = Logger.getLogger(AbstractWidgetPortlet.class);
    public static final String INIT_PARAM_CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String INIT_PARAM_ENTRY_EXPIRATION = "widgetExpiration";
    public static final String INIT_PARAM_QUERY_EXPIRATION = "queryExpiration";
    public static final String INIT_PARAM_FETCH_WIDGETS_ON_LOOKUP = "fetchWidgetsOnDirectoryLookup";
    protected final PortletMode EDIT_CONTENT = new PortletMode("edit_content");

    protected abstract WidgetProvider getProvider();

    public void init() throws PortletException {
        String fetchWidgetsOnDirectoryLookup;
        String entryExpiration;
        String queryExpiration;
        PortletConfig config = this.getPortletConfig();
        WidgetProvider provider = this.getProvider();
        String timeout = config.getInitParameter(INIT_PARAM_CONNECTION_TIMEOUT);
        if (timeout != null && timeout.length() > 0) {
            try {
                provider.setConnectionTimeout(Integer.parseInt(timeout));
            }
            catch (NumberFormatException e) {
                log.error((Object)"Failed to parse connectionTimeout init parameter - should be integer number: ", (Throwable)e);
            }
        }
        if ((queryExpiration = config.getInitParameter(INIT_PARAM_QUERY_EXPIRATION)) != null && queryExpiration.length() > 0) {
            try {
                int expiration = Integer.parseInt(queryExpiration) * 60;
                provider.setQueryExpiration(TimeUnit.MILLISECONDS.convert(expiration, TimeUnit.SECONDS));
            }
            catch (NumberFormatException e) {
                log.error((Object)"Failed to parse queryExpiration init parameter - should be integer number: ", (Throwable)e);
            }
        }
        if ((entryExpiration = config.getInitParameter(INIT_PARAM_ENTRY_EXPIRATION)) != null && entryExpiration.length() > 0) {
            try {
                int expiration = Integer.parseInt(entryExpiration) * 60;
                provider.setEntryExpiration(TimeUnit.MILLISECONDS.convert(expiration, TimeUnit.SECONDS));
            }
            catch (NumberFormatException e) {
                log.error((Object)"Failed to parse entryExpiration init parameter - should be integer number: ", (Throwable)e);
            }
        }
        if ((fetchWidgetsOnDirectoryLookup = config.getInitParameter(INIT_PARAM_FETCH_WIDGETS_ON_LOOKUP)) != null && fetchWidgetsOnDirectoryLookup.length() > 0) {
            provider.setFetchWidgetsOnDirectoryLookup(Boolean.parseBoolean(fetchWidgetsOnDirectoryLookup));
        }
        provider.start();
    }

    public void destroy() {
        WidgetProvider provider = this.getProvider();
        provider.stop();
    }
}

