/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portal.common.util.MultiValuedPropertyMap;
import org.jboss.portal.common.util.SimpleMultiValuedPropertyMap;
import org.jboss.portal.portlet.spi.ClientContext;

public class AbstractClientContext
implements ClientContext {
    private static final List<Cookie> NO_COOKIES = Collections.emptyList();
    private final String method;
    private final MultiValuedPropertyMap<String> headers;
    private final List<Cookie> cookies;

    public AbstractClientContext(HttpServletRequest request) {
        this(request, NO_COOKIES);
    }

    public AbstractClientContext(HttpServletRequest request, List<Cookie> additionalCookies) {
        List cookies;
        SimpleMultiValuedPropertyMap headers = new SimpleMultiValuedPropertyMap();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            Enumeration f = request.getHeaders(headerName);
            while (f.hasMoreElements()) {
                String headerValue = (String)f.nextElement();
                headers.addValue(headerName, (Object)headerValue);
            }
        }
        Cookie[] requestCookies = request.getCookies();
        int length = (requestCookies == null ? 0 : requestCookies.length) + (additionalCookies == null ? 0 : additionalCookies.size());
        if (length == 0) {
            cookies = Collections.emptyList();
        } else {
            cookies = new ArrayList(length);
            if (requestCookies != null) {
                for (Cookie cookie : requestCookies) {
                    if (cookie == null) continue;
                    Cookie copy = (Cookie)cookie.clone();
                    cookies.add(copy);
                }
            }
            if (additionalCookies != null) {
                for (Cookie cookie : additionalCookies) {
                    Cookie copy = (Cookie)cookie.clone();
                    cookies.add(copy);
                }
            }
        }
        this.headers = headers;
        this.method = request.getMethod();
        this.cookies = cookies;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public MultiValuedPropertyMap<String> getProperties() {
        return this.headers;
    }

    @Override
    public List<Cookie> getCookies() {
        return this.cookies;
    }
}

