/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.state.consumer;

import org.jboss.portal.portlet.state.InvalidStateIdException;
import org.jboss.portal.portlet.state.NoSuchStateException;
import org.jboss.portal.portlet.state.consumer.ConsumerPersistenceManager;
import org.jboss.portal.portlet.state.consumer.ConsumerState;
import org.jboss.portal.portlet.state.consumer.ConsumerStateContext;

public abstract class AbstractConsumerPersistenceManagerService
implements ConsumerPersistenceManager {
    private int counter = 0;

    protected abstract ConsumerStateContext get(String var1);

    protected abstract void put(String var1, ConsumerStateContext var2);

    protected abstract void remove(String var1);

    protected abstract int size();

    public synchronized ConsumerStateContext loadState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        this.checkId(stateId);
        ConsumerStateContext state = this.get(stateId);
        if (state == null) {
            throw new NoSuchStateException(stateId);
        }
        return state;
    }

    public synchronized String createState(ConsumerState state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        ConsumerStateContext ctx = new ConsumerStateContext(Integer.toString(this.counter++), state.getPortletId(), state.getBytes());
        this.put(ctx.getId(), ctx);
        return ctx.getId();
    }

    public synchronized void updateState(String stateId, ConsumerState state) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        this.checkId(stateId);
        if (state == null) {
            throw new IllegalArgumentException();
        }
        if (this.get(stateId) == null) {
            throw new NoSuchStateException(stateId);
        }
        this.put(stateId, new ConsumerStateContext(stateId, state.getPortletId(), state.getBytes()));
    }

    public synchronized void destroyState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        this.checkId(stateId);
        if (this.get(stateId) != null) {
            throw new NoSuchStateException(stateId);
        }
        this.remove(stateId);
    }

    public synchronized int getSize() {
        return this.size();
    }

    private void checkId(String stateId) throws IllegalArgumentException, InvalidStateIdException {
        if (stateId == null) {
            throw new IllegalArgumentException("No null state id accepted");
        }
        try {
            Integer.parseInt(stateId);
        }
        catch (NumberFormatException e) {
            throw new InvalidStateIdException(e, stateId);
        }
    }
}

