/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.actions;

import java.util.Set;
import org.jboss.portal.core.admin.ui.PortalObjectManagerBean;
import org.jboss.portal.core.admin.ui.dashboard.DashboardBean;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.faces.gui.ManagedBean;
import org.jboss.portal.security.spi.provider.DomainConfigurator;

public class RenameAction
extends ManagedBean {
    private String newName;
    public PortalObject renamedObject;
    private DomainConfigurator domainConfigurator;
    private Object bean;
    private static final String MESSAGE_TARGET = "renameForm:newName";
    protected static final String PORTAL_OBJECT_TYPE = "PORTAL_OBJECT_TYPE";

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        if (this.newName == null) {
            this.newName = this.renamedObject.getName();
        }
        return this.newName;
    }

    public DomainConfigurator getDomainConfigurator() {
        return this.domainConfigurator;
    }

    public void setDomainConfigurator(DomainConfigurator domainConfigurator) {
        this.domainConfigurator = domainConfigurator;
    }

    public PortalObject getRenamedObject() {
        return this.renamedObject;
    }

    public void setRenamedObject(PortalObject renamedObject) {
        this.renamedObject = renamedObject;
    }

    public String execute() {
        String currentName = this.renamedObject.getName();
        if (!this.isOldAndNewDifferent(currentName, this.newName)) {
            return null;
        }
        this.newName = this.checkNameValidity(this.newName, MESSAGE_TARGET);
        if (this.newName != null) {
            PortalObject parent = this.renamedObject.getParent();
            PortalObject newObject = null;
            try {
                newObject = this.renamedObject.copy(parent, this.newName, true);
                Set set = this.domainConfigurator.getSecurityBindings(this.renamedObject.getId().toString(PortalObjectPath.CANONICAL_FORMAT));
                this.domainConfigurator.setSecurityBindings(newObject.getId().toString(PortalObjectPath.CANONICAL_FORMAT), set);
                String defaultObject = (String)parent.getDeclaredProperties().get("portal.defaultObjectName");
                if (currentName.equals(defaultObject)) {
                    parent.setDeclaredProperty("portal.defaultObjectName", this.newName);
                }
                parent.destroyChild(currentName);
            }
            catch (Exception e) {
                this.log.error((Object)("An error occurred while attempting to rename " + this.renamedObject + "to " + this.newName));
                this.beanContext.createErrorMessageFrom(MESSAGE_TARGET, e);
            }
            if (this.bean instanceof PortalObjectManagerBean) {
                ((PortalObjectManagerBean)this.bean).selectObject(parent);
                return "objects";
            }
            if (this.bean instanceof DashboardBean) {
                ((DashboardBean)this.bean).selectedPageName = newObject.getName();
            }
        }
        return null;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    protected String getObjectTypeName() {
        return PORTAL_OBJECT_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.renamedObject.getParent().getChild(objectName) != null;
    }
}

