/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.request;

public final class URLContext {
    public static final int SEC_MASK = 1;
    public static final int AUTH_MASK = 2;
    private final int mask;
    private final boolean secure;
    private final boolean authenticated;
    private static final URLContext[] contexts = new URLContext[]{new URLContext(false, false), new URLContext(true, false), new URLContext(false, true), new URLContext(true, true)};

    private URLContext(boolean secure, boolean authenticated) {
        this.mask = (secure ? 1 : 0) | (authenticated ? 2 : 0);
        this.secure = secure;
        this.authenticated = authenticated;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public URLContext withSecured(Boolean wantSecure) {
        if (wantSecure == null) {
            return this;
        }
        if (Boolean.TRUE == wantSecure) {
            return this.asSecured();
        }
        return this.asNonSecured();
    }

    public URLContext asSecured() {
        int newMask = this.mask | 1;
        return contexts[newMask];
    }

    public URLContext asNonSecured() {
        int newMask = this.mask & 0xFFFFFFFE;
        return contexts[newMask];
    }

    public URLContext withAuthenticated(Boolean wantAuthenticated) {
        if (wantAuthenticated == null) {
            return this;
        }
        if (Boolean.TRUE == wantAuthenticated) {
            return this.asAuthenticated();
        }
        return this.asNonAuthenticated();
    }

    public URLContext asAuthenticated() {
        int newMask = this.mask | 2;
        return contexts[newMask];
    }

    public URLContext asNonAuthenticated() {
        int newMask = this.mask & 0xFFFFFFFD;
        return contexts[newMask];
    }

    public int getMask() {
        return this.mask;
    }

    public static URLContext newInstance(int mask) {
        return contexts[mask];
    }

    public static URLContext newInstance(boolean secure, boolean authenticated) {
        int mask = (secure ? 1 : 0) | (authenticated ? 2 : 0);
        return contexts[mask];
    }
}

