/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.services;

import java.net.URI;

public class NuxeoConnectionProperties {
    private static final String NUXEO_PUBLIC_HOST = System.getProperty("nuxeo.publicHost");
    private static final String NUXEO_PUBLIC_PORT = System.getProperty("nuxeo.publicPort");
    private static final String NUXEO_PRIVATE_HOST = System.getProperty("nuxeo.privateHost");
    private static final String NUXEO_PRIVATE_PORT = System.getProperty("nuxeo.privatePort");
    private static final String NUXEO_CONTEXT = "/nuxeo";

    public static final String getNuxeoContext() {
        return NUXEO_CONTEXT;
    }

    public static final URI getPublicDomainUri() {
        String scheme = "http";
        if ("443".equals(NUXEO_PUBLIC_PORT)) {
            scheme = "https";
        }
        try {
            URI uri = NUXEO_PUBLIC_HOST == null && NUXEO_PUBLIC_PORT == null ? new URI("") : ("80".equals(NUXEO_PUBLIC_PORT) || "443".equals(NUXEO_PUBLIC_PORT) ? new URI(scheme + "://" + NUXEO_PUBLIC_HOST) : new URI(scheme + "://" + NUXEO_PUBLIC_HOST + ":" + NUXEO_PUBLIC_PORT));
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final URI getPublicBaseUri() {
        try {
            String domain = NuxeoConnectionProperties.getPublicDomainUri().toString();
            return new URI(domain + NUXEO_CONTEXT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final URI getPrivateBaseUri() {
        try {
            return new URI("http://" + NUXEO_PRIVATE_HOST + ":" + NUXEO_PRIVATE_PORT + NUXEO_CONTEXT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

