/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.workspace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public enum WorkspaceType {
    PUBLIC("glyphicons glyphicons-unlock", "success"),
    PRIVATE("glyphicons glyphicons-lock", "warning"),
    INVITATION("glyphicons glyphicons-shield", "danger"),
    UNCHANGEABLE("glyphicons glyphicons-government", "default", true);

    private final String id = this.name();
    private final String key = "WORKSPACE_TYPE_" + StringUtils.upperCase((String)this.name());
    private final String icon;
    private final String color;
    private final boolean portalAdministratorRestriction;

    private WorkspaceType(String icon, String color) {
        this(icon, color, false);
    }

    private WorkspaceType(String icon, String color, boolean portalAdministratorRestriction) {
        this.icon = icon;
        this.color = color;
        this.portalAdministratorRestriction = portalAdministratorRestriction;
    }

    public static List<WorkspaceType> list(boolean admin) {
        ArrayList<WorkspaceType> results;
        WorkspaceType[] values = WorkspaceType.values();
        if (admin) {
            results = new ArrayList<WorkspaceType>(Arrays.asList(values));
        } else {
            results = new ArrayList(values.length);
            for (WorkspaceType value : values) {
                if (value.portalAdministratorRestriction) continue;
                results.add(value);
            }
        }
        return results;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isPortalAdministratorRestriction() {
        return this.portalAdministratorRestriction;
    }
}

