/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import org.jboss.portletbridge.context.AbstractExternalContext;
import org.jboss.portletbridge.context.EnumerationIterator;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletExternalContextImpl
extends AbstractExternalContext {
    public static final String ACTION_URL_DO_NOTHITG = "/JBossPortletBridge/actionUrl/do/nothing";
    private String namespace;
    private String _pathInfo = null;
    private String _servletPath = null;
    private String servletMappingSuffix;
    private String defaultJsfSuffix;
    private String servletMappingPrefix;
    private String viewId;

    public PortletExternalContextImpl(PortletContext context, PortletRequest request, PortletResponse response) {
        super(context, request, response);
        this.portletBridgeContext = (PortletBridgeContext)request.getAttribute(PortletBridgeContext.REQUEST_PARAMETER_NAME);
        if (null == this.portletBridgeContext) {
            throw new FacesException("No portlet bridge context");
        }
        this.windowState = this.portletBridgeContext.getWindowState();
        this.calculateViewId();
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    public String getResponseCharacterEncoding() {
        return null;
    }

    public String getResponseContentType() {
        return null;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        try {
            ActionRequest actionRequest = (ActionRequest)this.getPortletRequest();
            actionRequest.setCharacterEncoding(encoding);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String getRequestCharacterEncoding() {
        ActionRequest actionRequest = (ActionRequest)this.getPortletRequest();
        return actionRequest.getCharacterEncoding();
    }

    public String getRequestContentType() {
        return null;
    }

    protected PortletContext getPortletContext() {
        return (PortletContext)this.getContext();
    }

    protected PortletRequest getPortletRequest() {
        return (PortletRequest)this.getRequest();
    }

    protected PortletResponse getPortletResponse() {
        return (PortletResponse)this.getResponse();
    }

    public String getInitParameter(String name) {
        return this.getPortletContext().getInitParameter(name);
    }

    @Override
    protected String getNamespace() {
        if (null == this.namespace) {
            this.namespace = this.getRequestParameter("org.jboss.portletbridge.NAMESPACE");
            if (null == this.namespace) {
                throw new IllegalStateException("Can not determine portletbridge namespace");
            }
        }
        return this.namespace;
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getPortletContext().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getPortletContext().getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.getPortletContext().getResourcePaths(path);
    }

    @Override
    protected Enumeration<String> enumerateRequestParameterNames() {
        return this.getPortletRequest().getParameterNames();
    }

    @Override
    protected Object getContextAttribute(String name) {
        return this.getPortletContext().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getContextAttributeNames() {
        return this.getPortletContext().getAttributeNames();
    }

    @Override
    protected Enumeration<String> getInitParametersNames() {
        return this.getPortletContext().getInitParameterNames();
    }

    @Override
    protected Object getRequestAttribute(String name) {
        return this.getPortletRequest().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getRequestAttributeNames() {
        return this.getPortletRequest().getAttributeNames();
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap() {
        return this.getPortletRequest().getParameterMap();
    }

    @Override
    protected String[] getRequestParameterValues(String name) {
        return this.getPortletRequest().getParameterValues(name);
    }

    @Override
    protected String getRequestHeader(String name) {
        return this.getPortletRequest().getProperty(name);
    }

    @Override
    protected Enumeration<String> getRequestHeaderNames() {
        return this.getPortletRequest().getPropertyNames();
    }

    @Override
    protected String[] getRequestHeaderValues(String name) {
        Enumeration properties = this.getPortletRequest().getProperties(name);
        ArrayList<String> values = new ArrayList<String>();
        while (properties.hasMoreElements()) {
            String value = (String)properties.nextElement();
            values.add(value);
        }
        return values.toArray(EMPTY_STRING_ARRAY);
    }

    @Override
    protected String getRequestParameter(String name) {
        return this.getPortletRequest().getParameter(name);
    }

    @Override
    protected Object getSessionAttribute(String name) {
        return this.getPortletRequest().getPortletSession(true).getAttribute(name, 2);
    }

    @Override
    protected Enumeration<String> getSessionAttributeNames() {
        return this.getPortletRequest().getPortletSession(true).getAttributeNames(2);
    }

    @Override
    protected void removeContextAttribute(String name) {
        this.getPortletContext().removeAttribute(name);
    }

    @Override
    protected void removeRequestAttribute(String name) {
        this.getPortletRequest().removeAttribute(name);
    }

    @Override
    protected void removeSessionAttribute(String name) {
        this.getPortletRequest().getPortletSession(true).removeAttribute(name, 2);
    }

    @Override
    protected void setContextAttribute(String name, Object value) {
        this.getPortletContext().setAttribute(name, value);
    }

    @Override
    protected void setRequestAttribute(String name, Object value) {
        this.getPortletRequest().setAttribute(name, value);
    }

    @Override
    protected void setSessionAttribute(String name, Object value) {
        this.getPortletRequest().getPortletSession(true).setAttribute(name, value, 2);
    }

    public void dispatch(String path) throws IOException {
        if (null == path) {
            throw new NullPointerException("Path to new view is null");
        }
        throw new IllegalStateException("Dispatch to new view not at render phase");
    }

    @Override
    protected String createActionUrl(PortalActionURL actionUrl) {
        String windowStateParameter;
        String viewIdFromUrl = this.getViewIdFromUrl(actionUrl);
        actionUrl.setPath(this.getRequestContextPath() + ACTION_URL_DO_NOTHITG);
        actionUrl.setParameter("org.jboss.portletbridge.VIEWID", viewIdFromUrl);
        String modeParameter = actionUrl.getParameter("javax.portlet.faces.PortletMode");
        if (null != modeParameter) {
            PortletMode mode = new PortletMode(modeParameter);
            try {
                ((ActionResponse)this.getResponse()).setPortletMode(mode);
            }
            catch (PortletModeException e) {
                // empty catch block
            }
        }
        if (null != (windowStateParameter = actionUrl.getParameter("javax.portlet.faces.WindowState"))) {
            try {
                WindowState state = new WindowState(windowStateParameter);
                ((ActionResponse)this.getResponse()).setWindowState(state);
            }
            catch (WindowStateException e) {
                // empty catch block
            }
        }
        return actionUrl.toString();
    }

    @Override
    protected String encodeURL(String url) {
        return this.getPortletResponse().encodeURL(url);
    }

    public String getAuthType() {
        return this.getPortletRequest().getAuthType();
    }

    public String getRemoteUser() {
        Principal userPrincipal;
        String user = this.getPortletRequest().getRemoteUser();
        if (user == null && null != (userPrincipal = this.getUserPrincipal())) {
            user = userPrincipal.getName();
        }
        return user;
    }

    public String getRequestContextPath() {
        return this.getPortletRequest().getContextPath();
    }

    public Locale getRequestLocale() {
        return this.getPortletRequest().getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        return new EnumerationIterator<Locale>(this.getPortletRequest().getLocales());
    }

    public String getRequestPathInfo() {
        return this._pathInfo;
    }

    public String getRequestServletPath() {
        return this._servletPath;
    }

    public Object getSession(boolean create) {
        return this.getPortletRequest().getPortletSession(create);
    }

    public Principal getUserPrincipal() {
        return this.getPortletRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getPortletRequest().isUserInRole(role);
    }

    public void log(String message) {
        this.getPortletContext().log(message);
    }

    public void log(String message, Throwable exception) {
        this.getPortletContext().log(message, exception);
    }

    public void redirect(String url) throws IOException {
        if (null == url || url.length() < 0) {
            throw new NullPointerException("Path to redirect is null");
        }
        PortalActionURL actionURL = new PortalActionURL(url);
        if (url.startsWith("#") || !actionURL.isInContext(this.getRequestContextPath()) || "true".equalsIgnoreCase(actionURL.getParameter("javax.portlet.faces.DirectLink"))) {
            ((ActionResponse)this.getResponse()).sendRedirect(url);
        } else {
            this.internalRedirect(actionURL);
        }
    }

    protected void calculateViewId() {
        this.viewId = this.getPortletRequest().getParameter("org.jboss.portletbridge.VIEWID");
        if (null == this.viewId) {
            this.viewId = this.windowState.getViewId();
            if (null == this.viewId) {
                String portletModeName = this.getPortletRequest().getPortletMode().toString();
                PortletSession portletSession = this.getPortletRequest().getPortletSession(false);
                if (null != portletSession) {
                    String historyViewId = (String)portletSession.getAttribute("javax.portlet.faces.viewIdHistory." + portletModeName);
                    try {
                        PortalActionURL viewIdUrl = new PortalActionURL(historyViewId);
                        this.viewId = viewIdUrl.getPath();
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (null == this.viewId) {
                    this.viewId = this.windowState.getBridgeConfig().getDefaultViewIdMap().get(portletModeName);
                }
                if (null == this.viewId) {
                    throw new BridgeDefaultViewNotSpecifiedException();
                }
            }
        }
        List<String> servletMappings = this.windowState.getBridgeConfig().getFacesServletMappings();
        this.calculateServletPath(this.viewId, servletMappings);
    }

    protected void calculateServletPath(String viewId, List<String> servletMappings) {
        if (null != servletMappings && servletMappings.size() > 0) {
            String mapping = servletMappings.get(0);
            if (mapping.startsWith("*")) {
                int i;
                this.servletMappingSuffix = mapping.substring(mapping.indexOf(46));
                this.defaultJsfSuffix = this.getPortletContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                if (null == this.defaultJsfSuffix) {
                    this.defaultJsfSuffix = ".jsp";
                }
                if ((i = viewId.lastIndexOf(this.defaultJsfSuffix)) < 0) {
                    i = viewId.lastIndexOf(46);
                }
                if (i >= 0) {
                    viewId = viewId.substring(0, i) + this.servletMappingSuffix;
                }
                this._servletPath = viewId;
                this.getPortletRequest().setAttribute("javax.servlet.include.servlet_path", (Object)viewId);
                this.getPortletRequest().setAttribute("com.sun.faces.INVOCATION_PATH", (Object)this.servletMappingSuffix);
                this._pathInfo = null;
            } else if (mapping.endsWith("*")) {
                if ((mapping = mapping.substring(0, mapping.length() - 1)).endsWith("/")) {
                    mapping = mapping.substring(0, mapping.length() - 1);
                }
                this.servletMappingPrefix = this._servletPath = mapping;
                this.getPortletRequest().setAttribute("com.sun.faces.INVOCATION_PATH", (Object)mapping);
                this._pathInfo = viewId;
            } else {
                this._servletPath = null;
                this._pathInfo = viewId;
            }
        } else {
            this._servletPath = null;
            this._pathInfo = viewId;
        }
    }

    protected void internalRedirect(PortalActionURL actionURL) {
        String viewId = actionURL.getParameter("org.jboss.portletbridge.VIEWID");
        if (null != viewId) {
            try {
                viewId = URLDecoder.decode(viewId, "UTF8");
                this.portletBridgeContext.setRedirectViewId(viewId);
                Map<String, String[]> requestParameters = actionURL.getParameters();
                if (requestParameters.size() > 0) {
                    this.portletBridgeContext.setRedirectRequestParameters(requestParameters);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String getServletMappingSuffix() {
        return this.servletMappingSuffix;
    }

    public String getDefaultJsfSuffix() {
        return this.defaultJsfSuffix;
    }

    public String getServletMappingPrefix() {
        return this.servletMappingPrefix;
    }

    protected String getViewIdFromUrl(PortalActionURL url) {
        String viewId = url.getParameter("org.jboss.portletbridge.VIEWID");
        if (null == viewId) {
            int i;
            viewId = url.getPath();
            if (viewId.startsWith(this.getRequestContextPath())) {
                viewId = viewId.substring(this.getRequestContextPath().length());
            }
            if (null != this.getServletMappingPrefix()) {
                if (viewId.startsWith(this.getServletMappingPrefix())) {
                    viewId = viewId.substring(this.getServletMappingPrefix().length());
                }
            } else if (null != this.getServletMappingSuffix() && (i = viewId.lastIndexOf(this.getServletMappingSuffix())) >= 0) {
                viewId = viewId.substring(0, i) + this.getDefaultJsfSuffix();
            }
        }
        return viewId;
    }
}

