/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FQN
implements Serializable {
    private static final long serialVersionUID = -4843390736196899215L;
    private static final String[] EMPTY_ARRAY = new String[0];
    protected String[] names;
    private int hashCode;

    public FQN() {
        this.names = EMPTY_ARRAY;
        this.hashCode = 0;
    }

    public FQN(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.names = new String[]{name};
        this.hashCode = 0;
    }

    public FQN(String[] names) throws IllegalArgumentException {
        if (names == null) {
            throw new IllegalArgumentException("Names array must not be null");
        }
        this.names = new String[names.length];
        this.hashCode = 0;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null) {
                throw new IllegalArgumentException("One of the names is null");
            }
            this.names[i] = name;
        }
    }

    public FQN(FQN base, String name) throws IllegalArgumentException {
        if (base == null) {
            throw new IllegalArgumentException("Base cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.names = new String[base.names.length + 1];
        this.hashCode = 0;
        System.arraycopy(base.names, 0, this.names, 0, base.names.length);
        this.names[base.names.length] = name;
    }

    public FQN(FQN base, String[] relative) throws IllegalArgumentException {
        if (base == null) {
            throw new IllegalArgumentException("Base cannot be null");
        }
        if (relative == null) {
            throw new IllegalArgumentException("Relative cannot be null");
        }
        this.names = new String[base.names.length + relative.length];
        this.hashCode = 0;
        System.arraycopy(base.names, 0, this.names, 0, base.names.length);
        System.arraycopy(relative, 0, this.names, base.names.length, relative.length);
    }

    public FQN(FQN base, FQN relative) throws IllegalArgumentException {
        if (base == null) {
            throw new IllegalArgumentException("Base cannot be null");
        }
        if (relative == null) {
            throw new IllegalArgumentException("Relative cannot be null");
        }
        this.names = new String[base.names.length + relative.names.length];
        this.hashCode = 0;
        System.arraycopy(base.names, 0, this.names, 0, base.names.length);
        System.arraycopy(relative.names, 0, this.names, base.names.length, relative.names.length);
    }

    public int size() {
        return this.names.length;
    }

    public String getName(int index) throws ArrayIndexOutOfBoundsException {
        return this.names[index];
    }

    public String[] toArray() {
        String[] copy = new String[this.names.length];
        System.arraycopy(this.names, 0, copy, 0, copy.length);
        return copy;
    }

    public boolean isChildOf(FQN parent) throws IllegalArgumentException {
        if (parent == null) {
            throw new IllegalArgumentException("Cannot compare to null");
        }
        if (this.names.length != parent.names.length + 1) {
            return false;
        }
        for (int i = 0; i < parent.names.length; ++i) {
            String name = parent.names[i];
            if (name.equals(this.names[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FQN)) {
            return false;
        }
        FQN other = (FQN)obj;
        if (other.names.length != this.names.length) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i].equals(other.names[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.names.length == 0) {
            return 0;
        }
        if (this.hashCode == 0) {
            int tmp = 0;
            for (int i = 0; i < this.names.length; ++i) {
                tmp = tmp * 29 + this.names[i].hashCode();
            }
            this.hashCode = tmp;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.names.length; ++i) {
            buffer.append('/').append(this.names[i]);
        }
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.names.length);
        for (int i = 0; i < this.names.length; ++i) {
            out.writeObject(this.names[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.names = new String[in.readInt()];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = (String)in.readObject();
        }
    }
}

