/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ResourceLock;
import org.jacorb.imr.ServerInfo;

public class ImRServerInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected String command;
    protected boolean holding = false;
    protected String host;
    protected String name;
    protected boolean active;
    protected boolean restarting = false;
    private final List poas = new ArrayList();
    private ResourceLock poas_lock = null;

    public ImRServerInfo(String string, String string2, String string3) throws IllegalServerName {
        if (string == null || string.length() == 0) {
            throw new IllegalServerName(string);
        }
        this.name = string;
        this.host = string2;
        this.command = string3;
        this.active = false;
        this.poas_lock = new ResourceLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo toServerInfo() {
        POAInfo[] pOAInfoArray;
        this.poas_lock.gainExclusiveLock();
        List list = this.poas;
        synchronized (list) {
            ImRPOAInfo[] imRPOAInfoArray = this.poas.toArray(new ImRPOAInfo[this.poas.size()]);
            pOAInfoArray = new POAInfo[imRPOAInfoArray.length];
            for (int i = 0; i < pOAInfoArray.length; ++i) {
                pOAInfoArray[i] = imRPOAInfoArray[i].toPOAInfo();
            }
        }
        this.poas_lock.releaseExclusiveLock();
        return new ServerInfo(this.name, this.command, pOAInfoArray, this.host, this.active, this.holding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPOA(ImRPOAInfo imRPOAInfo) {
        if (!this.active) {
            this.active = true;
        }
        this.poas_lock.gainSharedLock();
        List list = this.poas;
        synchronized (list) {
            this.poas.add(imRPOAInfo);
        }
        this.poas_lock.releaseSharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPOANames() {
        String[] stringArray;
        List list = this.poas;
        synchronized (list) {
            ImRPOAInfo[] imRPOAInfoArray = (ImRPOAInfo[])this.poas.toArray(new POAInfo[this.poas.size()]);
            stringArray = new String[imRPOAInfoArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = imRPOAInfoArray[i].name;
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDown() {
        List list = this.poas;
        synchronized (list) {
            for (int i = 0; i < this.poas.size(); ++i) {
                ((ImRPOAInfo)this.poas.get((int)i)).active = false;
            }
        }
        this.active = false;
        this.restarting = false;
    }

    public synchronized void awaitRelease() {
        while (this.holding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void release() {
        this.holding = false;
        this.notifyAll();
    }

    public synchronized boolean shouldBeRestarted() {
        boolean bl;
        boolean bl2 = bl = !this.active && !this.restarting;
        if (bl) {
            this.restarting = true;
        }
        return bl;
    }

    public void setNotRestarting() {
        this.restarting = false;
    }
}

