/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.jaxrpc;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.security.Constants;
import org.jboss.ws.extensions.security.WSSecurityDispatcher;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public abstract class WSSecurityHandler
extends GenericHandler {
    private static Logger log = Logger.getLogger(WSSecurityHandler.class);

    public QName[] getHeaders() {
        return new QName[]{Constants.WSSE_HEADER_QNAME};
    }

    protected boolean handleInboundSecurity(MessageContext msgContext) {
        try {
            WSSecurityConfiguration configuration = this.getSecurityConfiguration(msgContext);
            if (configuration != null) {
                CommonMessageContext ctx = (CommonMessageContext)msgContext;
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                new WSSecurityDispatcher().decodeMessage(configuration, soapMessage, null);
            }
        }
        catch (SOAPException ex) {
            log.error((Object)"Cannot handle inbound ws-security", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean handleOutboundSecurity(MessageContext msgContext) {
        try {
            WSSecurityConfiguration configuration = this.getSecurityConfiguration(msgContext);
            if (configuration != null) {
                CommonMessageContext ctx = (CommonMessageContext)msgContext;
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                String user = (String)ctx.get("javax.xml.rpc.security.auth.username");
                String pass = (String)ctx.get("javax.xml.rpc.security.auth.password");
                new WSSecurityDispatcher().encodeMessage(configuration, soapMessage, null, user, pass);
            }
        }
        catch (SOAPException ex) {
            log.error((Object)"Cannot handle outbound ws-security", (Throwable)ex);
            return false;
        }
        return true;
    }

    private WSSecurityConfiguration getSecurityConfiguration(MessageContext msgContext) {
        EndpointMetaData epMetaData = ((CommonMessageContext)msgContext).getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        WSSecurityConfiguration config = serviceMetaData.getSecurityConfiguration();
        if (config == null) {
            try {
                WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
                UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
                config = wsseConfFactory.createConfiguration(vfsRoot, this.getConfigResourceName());
            }
            catch (IOException e) {
                throw new WSException("Cannot obtain security config: " + this.getConfigResourceName());
            }
            serviceMetaData.setSecurityConfiguration(config);
        }
        return config;
    }

    protected abstract String getConfigResourceName();
}

