/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.notifications;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osivia.portal.api.notifications.NotificationsType;

public final class Notifications {
    private final NotificationsType type;
    private final List<String> messages;
    private final long creationTime;
    private final long expirationTime;
    private Long errorCode;

    public Notifications(NotificationsType type) {
        this.type = type;
        this.messages = new ArrayList<String>();
        this.creationTime = new Date().getTime();
        this.expirationTime = 0L;
    }

    public Notifications(NotificationsType type, int duration) {
        this.type = type;
        this.messages = new ArrayList<String>();
        this.creationTime = new Date().getTime();
        this.expirationTime = this.creationTime + (long)duration;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public void addMessages(List<String> messages) {
        this.messages.addAll(messages);
    }

    public NotificationsType getType() {
        return this.type;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public Long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Long errorCode) {
        this.errorCode = errorCode;
    }
}

