/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.InitialContext;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.logging.Logger;
import org.jboss.util.CachePolicy;

public class DistributedTimedCachePolicy
extends TimerTask
implements CachePolicy {
    protected static Timer resolutionTimer = new Timer(true);
    protected static Logger log = Logger.getLogger(DistributedTimedCachePolicy.class);
    protected DistributedState entryMap;
    protected String category;
    protected String partitionName;
    protected int defaultLifetime;
    protected long now;
    protected int resolution;

    public DistributedTimedCachePolicy(String category, String partitionName, int defaultLifetime) {
        this(category, partitionName, defaultLifetime, 0);
    }

    public DistributedTimedCachePolicy(String category, String partitionName, int defaultLifetime, int resolution) {
        this.category = category;
        this.partitionName = partitionName;
        this.defaultLifetime = defaultLifetime;
        if (resolution <= 0) {
            resolution = 60;
        }
        this.resolution = resolution;
    }

    public void create() throws Exception {
        InitialContext ctx = new InitialContext();
        String jndiName = "/HAPartition/" + this.partitionName;
        HAPartition partition = (HAPartition)ctx.lookup(jndiName);
        this.entryMap = partition.getDistributedStateService();
        log.debug((Object)("Obtained DistributedState from partition=" + this.partitionName));
        this.now = System.currentTimeMillis();
    }

    public void start() {
        resolutionTimer.scheduleAtFixedRate((TimerTask)this, 0L, (long)(1000 * this.resolution));
    }

    public void stop() {
        super.cancel();
    }

    public void destroy() {
    }

    public Object get(Object key) {
        Serializable skey = (Serializable)key;
        TimedEntry entry = (TimedEntry)this.entryMap.get(this.category, skey);
        if (entry == null) {
            return null;
        }
        if (!entry.isCurrent(this.now) && !entry.refresh()) {
            entry.destroy();
            try {
                this.entryMap.remove(this.category, skey);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to remove expired entry", (Throwable)e);
            }
            return null;
        }
        Object value = entry.getValue();
        return value;
    }

    public Object peek(Object key) {
        Serializable skey = (Serializable)key;
        TimedEntry entry = (TimedEntry)this.entryMap.get(this.category, skey);
        Object value = null;
        if (entry != null) {
            value = entry.getValue();
        }
        return value;
    }

    public void insert(Object key, Object value) {
        Serializable skey = (Serializable)key;
        TimedEntry entry = (TimedEntry)this.entryMap.get(this.category, skey);
        if (entry != null) {
            throw new IllegalStateException("Attempt to insert duplicate entry");
        }
        if (!(value instanceof TimedEntry)) {
            Serializable svalue = (Serializable)value;
            entry = new DefaultTimedEntry(this.defaultLifetime, svalue);
        } else {
            entry = (TimedEntry)value;
        }
        entry.init(this.now);
        try {
            this.entryMap.set(this.category, skey, entry);
        }
        catch (Exception e) {
            log.error((Object)"Failed to set entry", (Throwable)e);
        }
    }

    public void remove(Object key) {
        Serializable skey = (Serializable)key;
        try {
            TimedEntry entry = (TimedEntry)this.entryMap.remove(this.category, skey);
            if (entry != null) {
                entry.destroy();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove entry", (Throwable)e);
        }
    }

    public void flush() {
        Collection keys = this.entryMap.getAllKeys(this.category);
        for (Serializable key : keys) {
            TimedEntry entry = (TimedEntry)this.entryMap.get(this.category, key);
            entry.destroy();
        }
    }

    public int size() {
        return this.entryMap.getAllKeys(this.category).size();
    }

    public int getDefaultLifetime() {
        return this.defaultLifetime;
    }

    public void setDefaultLifetime(int defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public void run() {
        this.now = System.currentTimeMillis();
    }

    public long currentTimeMillis() {
        return this.now;
    }

    public TimedEntry peekEntry(Object key) {
        Serializable skey = (Serializable)key;
        TimedEntry entry = (TimedEntry)this.entryMap.get(this.category, skey);
        return entry;
    }

    static class DefaultTimedEntry
    implements TimedEntry {
        long expirationTime;
        Serializable value;

        DefaultTimedEntry(long lifetime, Serializable value) {
            this.expirationTime = 1000L * lifetime;
            this.value = value;
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            return this.expirationTime > now;
        }

        public boolean refresh() {
            return false;
        }

        public void destroy() {
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static interface TimedEntry
    extends Serializable {
        public void init(long var1);

        public boolean isCurrent(long var1);

        public boolean refresh();

        public void destroy();

        public Object getValue();
    }
}

