/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.services;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.portal.core.cms.Satellite;
import org.springframework.util.StringUtils;

public class NuxeoSatelliteConnectionProperties {
    public static final String NUXEO_CONTEXT = "/nuxeo";
    private static Map<String, NuxeoSatelliteConnectionProperties> connections = new ConcurrentHashMap<String, NuxeoSatelliteConnectionProperties>();
    private final Satellite satellite;

    public NuxeoSatelliteConnectionProperties(Satellite satellite) {
        if (satellite == null || satellite.isMain()) {
            this.satellite = Satellite.MAIN;
            this.satellite.setPublicHost(System.getProperty("nuxeo.publicHost"));
            this.satellite.setPublicPort(System.getProperty("nuxeo.publicPort"));
            this.satellite.setPrivateHost(System.getProperty("nuxeo.privateHost"));
            this.satellite.setPrivatePort(System.getProperty("nuxeo.privatePort"));
        } else {
            Set satellites;
            ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
            ICMSService cmsService = cmsServiceLocator.getCMSService();
            try {
                satellites = cmsService.getSatellites();
            }
            catch (CMSException e) {
                satellites = null;
            }
            Satellite findedSatellite = null;
            if (CollectionUtils.isNotEmpty((Collection)satellites)) {
                Iterator iterator = satellites.iterator();
                while (findedSatellite == null && iterator.hasNext()) {
                    Satellite iSatellite = (Satellite)iterator.next();
                    if (!StringUtils.pathEquals((String)iSatellite.getId(), (String)satellite.getId())) continue;
                    findedSatellite = iSatellite;
                }
            }
            this.satellite = findedSatellite;
        }
    }

    public static NuxeoSatelliteConnectionProperties getConnectionProperties(Satellite satellite) {
        NuxeoSatelliteConnectionProperties conn;
        if (satellite == null) {
            satellite = Satellite.MAIN;
        }
        if ((conn = connections.get(satellite.getId())) == null) {
            conn = new NuxeoSatelliteConnectionProperties(satellite);
            connections.put(satellite.getId(), conn);
        }
        return conn;
    }

    public final URI getPublicDomainUri() {
        String publicHost = this.getPublicHost();
        String publicPort = this.getPublicPort();
        String scheme = "http";
        if ("443".equals(publicPort)) {
            scheme = "https";
        }
        try {
            URI uri = publicHost == null && publicPort == null ? new URI("") : ("80".equals(publicPort) || "443".equals(publicPort) ? new URI(scheme + "://" + publicHost) : new URI(scheme + "://" + publicHost + ":" + publicPort));
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final URI getPublicBaseUri() {
        try {
            String domain = this.getPublicDomainUri().toString();
            return new URI(domain + NUXEO_CONTEXT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final URI getPrivateBaseUri() {
        String privateHost = this.getPrivateHost();
        String privatePort = this.getPrivatePort();
        try {
            return new URI("http://" + privateHost + ":" + privatePort + NUXEO_CONTEXT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getPublicHost() {
        String publicHost = this.satellite == null ? null : this.satellite.getPublicHost();
        return publicHost;
    }

    private String getPublicPort() {
        String publicPort = this.satellite == null ? null : this.satellite.getPublicPort();
        return publicPort;
    }

    private String getPrivateHost() {
        String privateHost = this.satellite == null ? null : this.satellite.getPrivateHost();
        return privateHost;
    }

    private String getPrivatePort() {
        String privateHost = this.satellite == null ? null : this.satellite.getPrivatePort();
        return privateHost;
    }
}

