/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import javax.faces.context.FacesContext;
import org.jboss.portal.core.admin.ui.PropertiesInfo;
import org.jboss.portal.core.admin.ui.PropertyBeanContainer;
import org.jboss.portal.core.admin.ui.PropertyInfo;
import org.jboss.portal.core.model.portal.PortalObject;

public class PropertyBean
implements Comparable {
    protected String value;
    private final PropertyBeanContainer container;
    protected final PropertyInfo info;
    protected boolean inherited;
    protected boolean inheritable;

    public PropertyBean(PropertyBeanContainer container, PropertyInfo info, boolean inherited, boolean inheritable, String value) {
        this.container = container;
        this.info = info;
        this.inherited = inherited;
        this.inheritable = inheritable;
        this.value = value;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public String getName() {
        return this.info.getName();
    }

    public boolean isReadOnly() {
        return this.info.getAccessMode() == 0;
    }

    public String getDescription() {
        return this.info.getDescription().getString(FacesContext.getCurrentInstance().getExternalContext().getRequestLocale(), true);
    }

    public String getDisplayName() {
        return this.info.getDisplayName().getString(FacesContext.getCurrentInstance().getExternalContext().getRequestLocale(), true);
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public Object getValue() {
        if (this.info.getType().equals("java.lang.Boolean")) {
            return Boolean.valueOf(this.value);
        }
        return this.value;
    }

    public void setValue(Object value) {
        String parentValue;
        this.value = value.toString();
        PortalObject portalObject = this.container.getRelatedObject();
        if (this.isInherited() && value.equals(parentValue = portalObject.getProperty(this.getName()))) {
            return;
        }
        portalObject.setDeclaredProperty(this.getName(), value.toString());
    }

    public int compareTo(Object o) {
        PropertyBean that = (PropertyBean)o;
        return this.info.getName().compareTo(that.getName());
    }

    public String getType() {
        return this.info.getType();
    }

    public boolean isControlProperty() {
        return PropertiesInfo.isControlProperty(this.info.getName());
    }

    public String toString() {
        return "PropertyBean[name=" + this.info.getName() + ",value=" + this.value + "]";
    }
}

