/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.portal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.core.impl.model.portal.ContextImpl;
import org.jboss.portal.core.impl.model.portal.ObjectNode;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.content.spi.ContentProviderRegistry;
import org.jboss.portal.core.model.content.spi.handler.ContentHandler;
import org.jboss.portal.core.model.portal.Context;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.PortalObjectPermission;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalPermissionCollection;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.security.spi.provider.PermissionFactory;
import org.jboss.portal.security.spi.provider.PermissionRepository;
import org.jboss.portal.security.spi.provider.SecurityConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPortalObjectContainer
extends AbstractJBossService
implements PortalObjectContainer,
PermissionFactory,
AuthorizationDomain,
DomainConfigurator,
PermissionRepository {
    private ContentProviderRegistry contentProviderRegistry;

    protected AbstractPortalObjectContainer() {
    }

    public ContentProviderRegistry getContentProviderRegistry() {
        return this.contentProviderRegistry;
    }

    public void setContentProviderRegistry(ContentProviderRegistry contentProviderRegistry) {
        this.contentProviderRegistry = contentProviderRegistry;
    }

    @Override
    public Context getContext() {
        return this.getContext("");
    }

    @Override
    public PortalObject getObject(PortalObjectId id) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)id, (String)"id");
        ObjectNode node = this.getObjectNode(id);
        return node == null ? null : node.getObject();
    }

    @Override
    public <T extends PortalObject> T getObject(PortalObjectId id, Class<T> expectedType) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(expectedType, (String)"expected type");
        PortalObject object = this.getObject(id);
        if (expectedType.isInstance(object)) {
            return (T)((PortalObject)expectedType.cast(object));
        }
        return null;
    }

    @Override
    public Context getContext(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("No null namespace accepted");
        }
        PortalObjectId id = new PortalObjectId(namespace, PortalObjectPath.ROOT_PATH);
        ObjectNode node = this.getObjectNode(id);
        return node == null ? null : (Context)((Object)node.getObject());
    }

    @Override
    public Context createContext(String namespace) throws DuplicatePortalObjectException {
        if (namespace == null) {
            throw new IllegalArgumentException("No null namespace accepted");
        }
        return this.createRoot(namespace);
    }

    @Override
    public AuthorizationDomain getAuthorizationDomain() {
        return this;
    }

    protected abstract ContextImpl createRoot(String var1) throws DuplicatePortalObjectException;

    public String getType() {
        return "portalobject";
    }

    public DomainConfigurator getConfigurator() {
        return this;
    }

    public PermissionRepository getPermissionRepository() {
        return this;
    }

    public PermissionFactory getPermissionFactory() {
        return this;
    }

    public PortalPermission createPermissionContainer(PortalPermissionCollection collection) throws PortalSecurityException {
        return new PortalObjectPermission(collection);
    }

    public PortalPermission createPermission(String uri, String action) throws PortalSecurityException {
        PortalObjectId id = PortalObjectId.parse(uri, PortalObjectPath.CANONICAL_FORMAT);
        return new PortalObjectPermission(id, action);
    }

    public PortalPermission createPermission(String uri, Collection actions) throws PortalSecurityException {
        PortalObjectId id = PortalObjectId.parse(uri, PortalObjectPath.CANONICAL_FORMAT);
        return new PortalObjectPermission(id, actions);
    }

    public PortalPermission getPermission(String roleName, String uri) throws PortalSecurityException {
        RoleSecurityBinding binding;
        PortalObjectId id = PortalObjectId.parse(uri, PortalObjectPath.CANONICAL_FORMAT);
        ObjectNode on = this.getObjectNode(id);
        if (on != null && (binding = on.getBinding(roleName)) != null) {
            return this.createPermission(uri, binding.getActions());
        }
        return null;
    }

    public void removeSecurityBindings(String uri) throws SecurityConfigurationException {
        PortalObjectId id = PortalObjectId.parse(uri, PortalObjectPath.CANONICAL_FORMAT);
        ObjectNode on = this.getObjectNode(id);
        if (on == null) {
            throw new SecurityConfigurationException("The object should exist prior its security is configured : fixme");
        }
        on.setBindings(new HashSet());
    }

    public void setSecurityBindings(String uri, Set securityBindings) throws SecurityConfigurationException {
        PortalObjectId id = PortalObjectId.parse(uri, PortalObjectPath.CANONICAL_FORMAT);
        ObjectNode on = this.getObjectNode(id);
        if (on == null) {
            throw new SecurityConfigurationException("The object should exist prior its security is configured : fixme");
        }
        on.setBindings(securityBindings);
    }

    public Set getSecurityBindings(String uri) {
        PortalObjectId id = PortalObjectId.parse(uri, PortalObjectPath.CANONICAL_FORMAT);
        ObjectNode on = this.getObjectNode(id);
        if (on != null) {
            return on.getBindings();
        }
        return null;
    }

    protected abstract ObjectNode getObjectNode(PortalObjectId var1);

    public class ContainerContext {
        public PortalObjectContainer getContainer() {
            return AbstractPortalObjectContainer.this;
        }

        public ContentType getDefaultContentType() {
            return ContentType.PORTLET;
        }

        public void destroyChild(ObjectNode node) {
        }

        public void createChild(ObjectNode node) throws DuplicatePortalObjectException {
        }

        public void updated(ObjectNode node) {
        }

        public ContentHandler getContentHandler(ContentType contentType) {
            ContentProvider contentProvider = AbstractPortalObjectContainer.this.contentProviderRegistry.getContentProvider(contentType);
            if (contentProvider != null) {
                return contentProvider.getHandler();
            }
            return null;
        }
    }
}

