/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.control.page;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerRequestDispatcher;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.response.ErrorResponse;
import org.jboss.portal.core.controller.command.response.SecurityErrorResponse;
import org.jboss.portal.core.controller.command.response.UnavailableResourceResponse;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.command.response.MarkupResponse;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.core.model.portal.control.page.PageControlContext;
import org.jboss.portal.core.model.portal.control.page.PageControlPolicy;
import org.jboss.portal.server.config.ServerConfig;

public class DefaultPageControlPolicy
implements PageControlPolicy {
    private static final Logger log = Logger.getLogger(DefaultPageControlPolicy.class);
    private static final Map errorTypeMapping = new HashMap();
    private ServerConfig serverConfig;
    private PortalObjectContainer portalObjectContainer;

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public void doControl(PageControlContext controlContext) {
        Map<String, String> properties;
        String policyValue;
        WindowRendition rendition = controlContext.getRendition();
        ControllerResponse response = rendition.getControllerResponse();
        String policyKey = null;
        Throwable cause = null;
        String message = null;
        if (response instanceof ErrorResponse) {
            ErrorResponse error = (ErrorResponse)response;
            cause = error.getCause();
            message = error.getMessage();
            if (response instanceof SecurityErrorResponse) {
                SecurityErrorResponse ser = (SecurityErrorResponse)response;
                if (ser.getStatus() == 0) {
                    policyKey = "control.page.access_denied";
                }
            } else {
                policyKey = error.isInternal() ? "control.page.internal_error" : "control.page.error";
            }
        } else if (response instanceof UnavailableResourceResponse) {
            UnavailableResourceResponse unavailable = (UnavailableResourceResponse)response;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Window not found " + unavailable.getRef()));
            }
            String string = policyKey = unavailable.isLocated() ? "control.page.unavailable" : "control.page.not_found";
        }
        if (cause != null) {
            log.error((Object)"Rendering portlet window  produced an error", cause);
        }
        if (policyKey != null && (policyValue = (properties = controlContext.getRendition().getProperties()).get(policyKey)) != null) {
            ControllerContext controllerCtx;
            ControllerRequestDispatcher rd;
            String resourceURI;
            if ("hide".equals(policyValue)) {
                rendition.setControllerResponse(null);
            } else if ("jsp".equals(policyValue) && (resourceURI = properties.get("control.page.resource_uri")) != null && (rd = (controllerCtx = controlContext.getControllerContext()).getRequestDispatcher("/portal-core", resourceURI)) != null) {
                String errorType = (String)errorTypeMapping.get(policyKey);
                rd.setAttribute("org.jboss.portal.control.ERROR_TYPE", errorType);
                rd.setAttribute("org.jboss.portal.control.CAUSE", cause);
                rd.setAttribute("org.jboss.portal.control.MESSAGE", message);
                rd.include();
                String markup = rd.getMarkup();
                rendition.setSupportedWindowStates(Collections.EMPTY_LIST);
                rendition.setSupportedModes(Collections.EMPTY_LIST);
                rendition.setControllerResponse(new MarkupResponse("An error occured", markup, null));
            }
        }
    }

    static {
        errorTypeMapping.put("control.page.access_denied", "ACCESS_DENIED");
        errorTypeMapping.put("control.page.error", "ERROR");
        errorTypeMapping.put("control.page.internal_error", "INTERNAL_ERROR");
        errorTypeMapping.put("control.page.unavailable", "UNAVAILABLE");
        errorTypeMapping.put("control.page.not_found", "NOT_FOUND");
    }
}

