/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.theme.ThemeElement;

public final class ThemeLink
implements ThemeElement {
    private static final Log log = LogFactory.getLog(ThemeLink.class);
    private final String rel;
    private final String type;
    private final String href;
    private final String title;
    private final String media;
    private final String id;
    private final String link;

    public ThemeLink(String contextPath, String rel, String type, String href, String id, String title, String media) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create theme link with rel=" + rel + " type=" + type + " href=" + href + "title=" + title + " media=" + media));
        }
        this.rel = rel;
        this.type = type;
        this.href = href;
        this.title = title;
        this.media = media;
        this.id = id;
        this.link = ThemeLink.buildLinkMarkup(contextPath, rel, type, href, id, title, media);
    }

    public String getLink() {
        return this.link;
    }

    public String toString() {
        return this.link;
    }

    @Override
    public String getElement() {
        return this.getLink();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        if ("rel".equals(attributeName)) {
            return this.rel;
        }
        if ("type".equals(attributeName)) {
            return this.type;
        }
        if ("href".equals(attributeName)) {
            return this.href;
        }
        if ("title".equals(attributeName)) {
            return this.title;
        }
        if ("media".equals(attributeName)) {
            return this.media;
        }
        if ("id".equals(attributeName)) {
            return this.id;
        }
        return null;
    }

    private static String buildLinkMarkup(String contextPath, String rel, String type, String href, String id, String title, String media) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"build link markup...");
        }
        StringBuffer link = new StringBuffer();
        link.append("<link rel=\"").append(rel).append("\"");
        if (type != null) {
            link.append(" type=\"").append(type).append("\"");
        }
        if (id != null && !"".equals(id)) {
            link.append(" id=\"").append(id).append("\"");
        }
        if (href != null) {
            StringBuffer correctHREF = new StringBuffer();
            if (href.startsWith("/")) {
                correctHREF.append(contextPath);
            }
            correctHREF.append(href);
            link.append(" href=\"").append(correctHREF).append("\"");
        }
        if (title != null && !"".equals(title)) {
            link.append(" title=\"").append(title).append("\"");
        }
        if (media != null && !"".equals(media)) {
            link.append(" media=\"").append(media).append("\"");
        }
        link.append(" />");
        if (log.isDebugEnabled()) {
            log.debug((Object)("returning: " + link));
        }
        return link.toString();
    }
}

