/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.theme.LayoutDispatcher;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.impl.JSPRendererContext;
import org.jboss.portal.theme.impl.RendererFactoryImpl;
import org.jboss.portal.theme.impl.WriterRendererContext;
import org.jboss.portal.theme.impl.render.dynamic.DynaRenderOptions;
import org.jboss.portal.theme.page.PageResult;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.page.WindowResult;
import org.jboss.portal.theme.render.ObjectRendererContext;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.ThemeContext;
import org.jboss.portal.theme.render.renderer.PageRenderer;
import org.jboss.portal.theme.render.renderer.PageRendererContext;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;
import org.jboss.portal.web.ServletContextDispatcher;

public final class JSPLayout
extends PortalLayout
implements PageRenderer {
    @Override
    public RendererContext getRenderContext(ThemeContext themeContext, MarkupInfo markupInfo, ServletContextDispatcher dispatcher) {
        RendererFactoryImpl factory = new RendererFactoryImpl(this, this.serviceInfo, this.info);
        return new JSPRendererContext(themeContext, factory, dispatcher, markupInfo);
    }

    @Override
    public RendererContext getRenderContext(ThemeContext themeContext, MarkupInfo markupInfo, ServletContextDispatcher dispatcher, Writer writer) {
        RendererFactoryImpl factory = new RendererFactoryImpl(this, this.serviceInfo, this.info);
        return new WriterRendererContext(themeContext, factory, dispatcher, markupInfo, new PrintWriter(writer));
    }

    @Override
    public void startContext(RendererContext rendererContext, ObjectRendererContext objectRenderContext) {
    }

    @Override
    public void endContext(RendererContext rendererContext, ObjectRendererContext objectRenderContext) {
    }

    @Override
    public void render(RendererContext rendererContext, PageRendererContext prc) throws RenderException {
        PageResult pageResult = (PageResult)prc;
        for (String windowId : pageResult.getWindowIds()) {
            WindowContext wc = pageResult.getWindowContext(windowId);
            WindowResult res = wc.getResult();
            if (!WindowState.MAXIMIZED.equals((Object)res.getWindowState())) continue;
            RegionRendererContext srcRegion = pageResult.getRegion(wc.getRegionName());
            Map srcProps = srcRegion.getProperties();
            pageResult.setLayoutState("maximized");
            wc.setRegionName("maximized");
            wc.setOrder("0");
            pageResult.rebuild();
            RegionRendererContext dstRegion = pageResult.getRegion("maximized");
            Map dstProps = dstRegion.getProperties();
            dstProps.putAll(srcProps);
            DynaRenderOptions options = DynaRenderOptions.getOptions(Boolean.FALSE, null);
            options.setOptions(dstProps);
            break;
        }
        try {
            String layoutState = pageResult.getLayoutState();
            String layoutURI = this.getLayoutInfo().getURI(layoutState);
            LayoutDispatcher dispatcher = new LayoutDispatcher(rendererContext, prc, layoutURI, this.getLayoutInfo());
            dispatcher.include();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }
}

