/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl.render.dynamic;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.portal.theme.impl.render.dynamic.DynaResponse;
import org.jboss.portal.theme.impl.render.dynamic.json.JSONException;
import org.jboss.portal.theme.impl.render.dynamic.json.JSONWriter;
import org.jboss.portal.theme.impl.render.dynamic.response.PageResource;
import org.jboss.portal.theme.impl.render.dynamic.response.UpdatePageLocationResponse;
import org.jboss.portal.theme.impl.render.dynamic.response.UpdatePageStateResponse;

public class JSONMarshaller {
    public void write(DynaResponse response, Writer w) throws IOException {
        block25: {
            JSONWriter writer = new JSONWriter(w);
            try {
                if (response instanceof UpdatePageStateResponse) {
                    Object fragment;
                    String id;
                    UpdatePageStateResponse umr = (UpdatePageStateResponse)response;
                    writer.object();
                    writer.key("type").value("update_markup");
                    if (umr.getViewState() != null) {
                        writer.key("view_state").value(umr.getViewState());
                    }
                    if (umr.getSessionCheck() != null) {
                        writer.key("session_check").value(umr.getSessionCheck());
                    }
                    if (umr.getRestoreUrl() != null) {
                        writer.key("pop_url").value(umr.getRestoreUrl());
                    }
                    if (umr.getFullStateUrl() != null) {
                        writer.key("full_state_url").value(umr.getFullStateUrl());
                    }
                    if (umr.getPortalRedirection() != null) {
                        writer.key("portal_redirection").value(umr.getPortalRedirection());
                    }
                    if (umr.getPageChanged() != null) {
                        writer.key("page_changed").value(umr.getPageChanged().toString());
                    }
                    if (umr.getPushHistory() != null) {
                        writer.key("push_history").value(umr.getPushHistory().toString());
                    }
                    if (umr.getChangeState() != null) {
                        writer.key("change_state").value(umr.getChangeState());
                    }
                    writer.key("fragments").object();
                    for (Map.Entry entry : umr.getFragments().entrySet()) {
                        id = (String)entry.getKey();
                        fragment = (String)entry.getValue();
                        writer.key(id).value(fragment);
                    }
                    writer.endObject();
                    writer.key("resources");
                    writer.array();
                    for (PageResource pageResource : umr.getResources()) {
                        if (!"SCRIPT".equals(pageResource.getTag()) && !"LINK".equals(pageResource.getTag())) continue;
                        writer.object();
                        if (StringUtils.isNotEmpty((CharSequence)pageResource.getTag())) {
                            writer.key("tag").value(pageResource.getTag());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)pageResource.getRel())) {
                            writer.key("rel").value(pageResource.getRel());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)pageResource.getType())) {
                            writer.key("type").value(pageResource.getType());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)pageResource.getHref())) {
                            writer.key("href").value(pageResource.getHref());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)pageResource.getSrc())) {
                            writer.key("src").value(pageResource.getSrc());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)pageResource.getMedia())) {
                            writer.key("media").value(pageResource.getMedia());
                        }
                        writer.endObject();
                    }
                    writer.endArray();
                    writer.key("regions").object();
                    for (Map.Entry entry : umr.getRegions().entrySet()) {
                        id = (String)entry.getKey();
                        writer.key(id);
                        writer.array();
                        for (String windowId : (List)entry.getValue()) {
                            writer.value(windowId);
                        }
                        writer.endArray();
                    }
                    writer.endObject();
                    writer.key("async_windows").object();
                    for (Map.Entry entry : umr.getAsyncWindows().entrySet()) {
                        id = (String)entry.getKey();
                        fragment = (String)entry.getValue();
                        writer.key(id).value(fragment);
                    }
                    writer.endObject();
                    if (umr.getLayout() != null) {
                        writer.key("layout").value(umr.getLayout());
                    }
                    writer.endObject();
                    break block25;
                }
                if (response instanceof UpdatePageLocationResponse) {
                    UpdatePageLocationResponse upr = (UpdatePageLocationResponse)response;
                    writer.object();
                    writer.key("type").value("update_page");
                    writer.key("location").value(upr.getLocation());
                    writer.endObject();
                    break block25;
                }
                throw new IllegalArgumentException();
            }
            catch (JSONException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                IOException iOException = new IOException();
                iOException.initCause(e);
                throw iOException;
            }
        }
    }
}

