/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.error;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.error.ErrorDescriptor;
import org.osivia.portal.core.error.IPortalLogger;
import org.osivia.portal.core.error.UserAction;
import org.osivia.portal.core.tracker.ITracker;

public class GlobalErrorHandler {
    private static final String DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final String TIME_FORMAT = "HH:mm:ss";
    protected static Log logger = LogFactory.getLog((String)"PORTAL_ERROR");
    private static GlobalErrorHandler s_instance = null;
    private Log log = LogFactory.getLog((String)"PORTAL_USER_ERROR");

    public static synchronized GlobalErrorHandler getInstance() {
        if (s_instance == null) {
            s_instance = new GlobalErrorHandler();
        }
        return s_instance;
    }

    protected GlobalErrorHandler() {
    }

    public synchronized void logError(ErrorDescriptor error) {
        int errorCode = error.getHttpErrCode();
        Map<String, Object> properties = error.getProperties();
        String url = null;
        HttpServletRequest request = null;
        ITracker tracker = (ITracker)Locator.findMBean(ITracker.class, (String)"osivia:service=Tracker");
        if (tracker != null && (request = tracker.getHttpRequest()) != null) {
            url = (String)request.getAttribute("osivia.trace.url");
        }
        if (properties.get("osivia.url") != null) {
            url = (String)properties.get("osivia.url");
        }
        String userAgent = "";
        if (request != null) {
            userAgent = request.getHeader("User-Agent");
        }
        if (properties.get("osivia.header.userAgent") != null) {
            userAgent = (String)properties.get("osivia.header.userAgent");
        }
        this.log.error((Object)GlobalErrorHandler.asString(error, url, request, userAgent));
        String msg = "#" + error.getToken() + "# ";
        String displayContext = (String)properties.get("osivia.cms.target");
        displayContext = displayContext != null ? "nx:" + displayContext : ((displayContext = (String)properties.get("osivia.portal.portalObject")) != null ? "portal:" + displayContext : ((displayContext = (String)properties.get("osivia.portal.portlet")) != null ? "porlet:" + displayContext : url));
        if (displayContext != null) {
            msg = msg + " [" + displayContext + "]";
        }
        String applicativeMessage = null;
        if (error.getMessage() != null) {
            applicativeMessage = error.getMessage();
        } else {
            if (errorCode == 500) {
                applicativeMessage = "Technical error";
            }
            if (errorCode == 404) {
                applicativeMessage = "Not found";
            }
            if (errorCode == 403) {
                applicativeMessage = "Forbidden";
            }
            if (errorCode == 408) {
                applicativeMessage = "Timeout expired";
            }
        }
        if ((errorCode == 500 || errorCode == 408) && applicativeMessage != null) {
            IPortalLogger.logger.error((Object)error);
        }
        if (applicativeMessage != null) {
            msg = msg + " " + applicativeMessage;
        }
        logger.error((Object)msg);
    }

    private static String asString(ErrorDescriptor error, String url, HttpServletRequest request, String userAgent) {
        StringBuffer sb = new StringBuffer();
        GlobalErrorHandler.appendAsText(sb, error, url, request, userAgent);
        return sb.toString();
    }

    private static void appendAsText(StringBuffer sb, ErrorDescriptor error, String url, HttpServletRequest request, String userAgent) {
        if (error != null) {
            Map<String, Object> errContext;
            int errorCode;
            String userId;
            sb.append("\n\n----------------------------------------------------------------\n");
            sb.append("\ntoken: " + error.getToken());
            Date errDate = error.getDate();
            if (errDate != null) {
                sb.append("\ndate: ");
                sb.append(GlobalErrorHandler.format(errDate));
                sb.append("\n");
            }
            if (GlobalErrorHandler.isNotEmpty(userId = error.getUserId())) {
                sb.append("user: ");
                sb.append(userId);
                sb.append("\n");
            }
            if ((errorCode = error.getHttpErrCode()) != -1) {
                sb.append("http code: ");
                sb.append(errorCode);
                sb.append("\n");
            }
            if (GlobalErrorHandler.isNotEmpty(url)) {
                sb.append("url: ");
                sb.append(url);
                sb.append("\n");
            }
            if (GlobalErrorHandler.isNotEmpty(userAgent)) {
                sb.append("userAgent: ");
                sb.append(userAgent);
                sb.append("\n");
            }
            if ((errContext = error.getProperties()) != null) {
                for (Map.Entry<String, Object> entry : errContext.entrySet()) {
                    String key = entry.getKey();
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"osivia.url") || StringUtils.equals((CharSequence)key, (CharSequence)"osivia.header.userAgent")) continue;
                    sb.append(entry.getKey()).append(": ");
                    sb.append(entry.getValue());
                    sb.append("\n");
                }
                sb.append("\n");
            }
            if (error.getMessage() != null) {
                sb.append("msg: " + error.getMessage());
                sb.append("\n");
            }
            if (error.getException() != null) {
                sb.append("stack: \n");
                sb.append(error.getStack());
            }
            if (request != null) {
                try {
                    HttpSession session = request.getSession();
                    List historic = (List)session.getAttribute("osivia.trace.historic");
                    if (historic != null && historic.size() > 0) {
                        sb.append("history: ");
                        String display = "";
                        for (UserAction userAction : historic) {
                            display = display + "\n  " + GlobalErrorHandler.formatTime(new Date(userAction.getTimestamp())) + " : " + userAction.getCommand() + " ";
                        }
                        sb.append(display);
                        sb.append("\n\n");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String format(Date date) {
        return new SimpleDateFormat(DATE_TIME_FORMAT).format(date);
    }

    private static String formatTime(Date date) {
        return new SimpleDateFormat(TIME_FORMAT).format(date);
    }

    private static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }
}

