/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.repository;

import fr.toutatice.portail.cms.nuxeo.repository.NuxeoRepositoryImpl;
import java.util.List;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.exception.CMSException;
import org.osivia.portal.api.cms.model.NavigationItem;

public class NuxeoNavigationItem
implements NavigationItem {
    private NuxeoRepositoryImpl repository;
    private UniversalID documentId;
    private String title;
    private boolean root;
    private UniversalID spaceId;
    private String spacePath;
    private String docPath;
    private UniversalID customizedTemplateId;

    public NuxeoNavigationItem(NuxeoRepositoryImpl repository, UniversalID documentId, String title, UniversalID spaceId, String spacePath, String docPath) {
        this.repository = repository;
        this.documentId = documentId;
        this.title = title;
        this.root = spacePath.equals(docPath);
        this.spaceId = spaceId;
        this.spacePath = spacePath;
        this.docPath = docPath;
    }

    public boolean isRoot() {
        return this.root;
    }

    public UniversalID getDocumentId() {
        return this.documentId;
    }

    public String getTitle() {
        return this.title;
    }

    public NavigationItem getParent() throws CMSException {
        return this.repository.computeParentNavigationItem(this.spacePath, this.docPath, this.spaceId.getInternalID());
    }

    public List<NavigationItem> getChildren() throws CMSException {
        return this.repository.computeChildrenNavigationItem(this.spacePath, this.docPath, this.spaceId.getInternalID());
    }

    public UniversalID getSpaceId() {
        return this.spaceId;
    }

    public UniversalID getCustomizedTemplateId() {
        return this.customizedTemplateId;
    }

    public void setCustomizedTemplateId(UniversalID customizedTemplateId) {
        this.customizedTemplateId = customizedTemplateId;
    }

    public boolean isVisible() {
        return true;
    }
}

