/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.services;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.nuxeo.ecm.automation.client.Session;

public class EndTransactionCommand
implements INuxeoCommand {
    private boolean commit;
    private String transactionId;

    public EndTransactionCommand(String transactionId, boolean commit) {
        this.commit = commit;
        this.transactionId = transactionId;
    }

    public Object execute(Session session) throws Exception {
        try {
            if (!this.commit) {
                session.newRequest("Repository.MarkTransactionAsRollback").setHeader("Tx-conversation-id", this.transactionId).execute();
            }
            session.newRequest("Repository.CommitOrRollbackTransaction").setHeader("Tx-conversation-id", this.transactionId).execute();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public String getId() {
        return "Endtransaction/" + this.transactionId + "/commit/" + this.commit;
    }
}

