/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.services;

import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoSatelliteConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceInvocationHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import fr.toutatice.portail.cms.nuxeo.services.NuxeoCommandCacheInvoker;
import fr.toutatice.portail.cms.nuxeo.services.NuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.services.NuxeoServiceMBean;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.PortalSSOAuthInterceptor;
import org.osivia.portal.api.profiler.IProfilerService;
import org.osivia.portal.core.cms.Satellite;

public class NuxeoService
implements NuxeoServiceMBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(NuxeoService.class);
    private INuxeoCustomizer cmsCustomizer;
    private transient IProfilerService profiler;
    private final INuxeoTagService tagService = this.createProxy(INuxeoTagService.class);
    private final IFormsService formsService = this.createProxy(IFormsService.class);

    private <T> T createProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new NuxeoServiceInvocationHandler());
    }

    @Override
    public IProfilerService getProfiler() {
        return this.profiler;
    }

    @Override
    public void setProfiler(IProfilerService profiler) {
        this.profiler = profiler;
    }

    @Override
    @PreDestroy
    public void stopService() throws Exception {
        logger.info((Object)"Gestionnaire nuxeo arrete");
    }

    @Override
    @PostConstruct
    public void startService() throws Exception {
        logger.info((Object)"Gestionnaire nuxeo demarre");
    }

    public Session createUserSession(Satellite satellite, String userId) throws Exception {
        long begin = System.currentTimeMillis();
        boolean error = false;
        Session session = null;
        try {
            if (satellite == null) {
                satellite = Satellite.MAIN;
            }
            String secretKey = System.getProperty("nuxeo.secretKey");
            URI uri = NuxeoSatelliteConnectionProperties.getConnectionProperties((Satellite)satellite).getPrivateBaseUri();
            String url = uri.toString() + "/site/automation";
            HttpAutomationClient client = new HttpAutomationClient(url, satellite);
            if (userId != null) {
                client.setRequestInterceptor((RequestInterceptor)new PortalSSOAuthInterceptor(secretKey, userId));
            }
            session = client.getSession();
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            long elapsedTime = end - begin;
            String nuxeoUserId = userId;
            if (nuxeoUserId == null) {
                nuxeoUserId = "null";
            }
            String name = "createAutomationSession,user='" + nuxeoUserId;
            if (session != null) {
                name = name + ", nuxeoSession=" + session.hashCode();
            }
            this.profiler.logEvent("NUXEO/" + satellite.getId(), name, elapsedTime, error);
        }
        return session;
    }

    public void registerCMSCustomizer(INuxeoCustomizer CMSCustomizer) {
        this.cmsCustomizer = CMSCustomizer;
    }

    public INuxeoCustomizer getCMSCustomizer() {
        return this.cmsCustomizer;
    }

    public INuxeoTagService getTagService() {
        return this.tagService;
    }

    public IFormsService getFormsService() {
        return this.formsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        Map<String, Session> sessions = NuxeoCommandCacheInvoker.getUserSessions(sessionEvent.getSession());
        if (sessions != null) {
            for (String sessionName : sessions.keySet()) {
                long begin = System.currentTimeMillis();
                boolean error = false;
                try {
                    sessions.get(sessionName).getClient().shutdown();
                }
                finally {
                    long end = System.currentTimeMillis();
                    long elapsedTime = end - begin;
                    String name = "shutdown";
                    this.profiler.logEvent("NUXEO/" + sessionName, name, elapsedTime, error);
                }
            }
        }
        this.getCMSCustomizer().sessionDestroyed(sessionEvent);
    }

    public INuxeoCommandService startNuxeoCommandService(PortletContext portletCtx) throws Exception {
        return new NuxeoCommandService();
    }
}

