/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.TextEscapeUtils;
import org.springframework.web.util.TagUtils;

public class AuthenticationTag
extends TagSupport {
    private String var;
    private String property;
    private int scope;
    private boolean scopeSpecified;
    private boolean htmlEscape = true;

    public AuthenticationTag() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.scopeSpecified = false;
        this.scope = 1;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setProperty(String operation) {
        this.property = operation;
    }

    public void setScope(String scope) {
        this.scope = TagUtils.getScope((String)scope);
        this.scopeSpecified = true;
    }

    public int doStartTag() throws JspException {
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        Object result = null;
        if (this.property != null) {
            if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
                return 6;
            }
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth.getPrincipal() == null) {
                return 6;
            }
            try {
                BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)auth);
                result = wrapper.getPropertyValue(this.property);
            }
            catch (BeansException e) {
                throw new JspException((Throwable)e);
            }
        }
        if (this.var != null) {
            if (result != null) {
                this.pageContext.setAttribute(this.var, result, this.scope);
            } else if (this.scopeSpecified) {
                this.pageContext.removeAttribute(this.var, this.scope);
            } else {
                this.pageContext.removeAttribute(this.var);
            }
        } else if (this.htmlEscape) {
            this.writeMessage(TextEscapeUtils.escapeEntities((String)String.valueOf(result)));
        } else {
            this.writeMessage(String.valueOf(result));
        }
        return 6;
    }

    protected void writeMessage(String msg) throws JspException {
        try {
            this.pageContext.getOut().write(String.valueOf(msg));
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
    }

    public void setHtmlEscape(String htmlEscape) {
        this.htmlEscape = Boolean.parseBoolean(htmlEscape);
    }

    protected boolean isHtmlEscape() {
        return this.htmlEscape;
    }
}

