/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import java.util.Locale;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.nuxeo.ecm.automation.client.model.NxDocumentMock;
import org.osivia.portal.api.cms.CMSContext;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.exception.CMSException;
import org.osivia.portal.api.cms.service.CMSService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locale.ILocaleService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.WindowFactory;

public class NxControllerMock {
    String basePath;
    String navigationPath;
    String itemNavigationPath;
    private CMSService cmsService;
    private ILocaleService localeService;
    private CMSContext cmsContext;
    private PortalControllerContext portalCtx;
    PortletRequest request;
    public final UniversalID navigationId;
    public final UniversalID contentId;
    public final UniversalID spaceId;

    public PortletRequest getRequest() {
        return this.request;
    }

    public CMSService getCMSService() {
        if (this.cmsService == null) {
            this.cmsService = (CMSService)Locator.getService(CMSService.class);
        }
        return this.cmsService;
    }

    public ILocaleService getLocaleService() {
        if (this.localeService == null) {
            this.localeService = (ILocaleService)Locator.getService(ILocaleService.class);
        }
        return this.localeService;
    }

    public CMSContext getCMSContext() {
        if (this.cmsContext == null) {
            this.cmsContext = new CMSContext(this.portalCtx);
            String sPreview = WindowFactory.getWindow((PortletRequest)this.portalCtx.getRequest()).getPageProperty("osivia.content.preview");
            this.cmsContext.setPreview(BooleanUtils.toBoolean((String)sPreview));
            String sLocale = WindowFactory.getWindow((PortletRequest)this.portalCtx.getRequest()).getPageProperty("osivia.content.locale");
            this.cmsContext.setLocale(new Locale(sLocale));
        }
        return this.cmsContext;
    }

    public String getNavigationPath() throws RuntimeException {
        if (this.navigationPath == null && this.navigationId != null) {
            try {
                UniversalID docId = this.navigationId;
                NxDocumentMock doc = (NxDocumentMock)this.getCMSService().getCMSSession(this.getCMSContext()).getDocument(docId).getNativeItem();
                this.navigationPath = doc.getPath();
            }
            catch (CMSException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        return this.navigationPath;
    }

    public String getBasePath() throws RuntimeException {
        if (this.basePath == null && this.spaceId != null) {
            try {
                UniversalID docId = this.spaceId;
                NxDocumentMock doc = (NxDocumentMock)this.getCMSService().getCMSSession(this.getCMSContext()).getDocument(docId).getNativeItem();
                this.basePath = doc.getPath();
            }
            catch (CMSException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        return this.basePath;
    }

    public String getItemNavigationPath() throws RuntimeException {
        if (this.itemNavigationPath == null && this.contentId != null) {
            try {
                UniversalID docId = this.contentId;
                NxDocumentMock doc = (NxDocumentMock)this.getCMSService().getCMSSession(this.cmsContext).getDocument(docId).getNativeItem();
                this.itemNavigationPath = doc.getPath();
            }
            catch (CMSException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        return this.itemNavigationPath;
    }

    public UniversalID getSpaceId() {
        return this.spaceId;
    }

    public NxControllerMock(PortletRequest request, PortletResponse response, PortletContext portletCtx) throws RuntimeException {
        this.request = request;
        this.contentId = new UniversalID(WindowFactory.getWindow((PortletRequest)request).getPageProperty("osivia.contentId"));
        this.navigationId = new UniversalID(WindowFactory.getWindow((PortletRequest)request).getPageProperty("osivia.navigationId"));
        this.spaceId = new UniversalID(WindowFactory.getWindow((PortletRequest)request).getPageProperty("osivia.spaceId"));
        this.portalCtx = new PortalControllerContext(portletCtx, request, response);
    }

    public NxControllerMock(PortalControllerContext portalControllerContext) {
        this(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
    }
}

