/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.portlet.PortalGenericPortlet;

public class DocumentType
implements Cloneable {
    private boolean folderish;
    private boolean browsable;
    private boolean navigable;
    private boolean ordered;
    private boolean forceContextualization;
    private boolean root;
    private boolean file;
    private String icon;
    private boolean editable;
    private boolean movable;
    private boolean preventedCreation;
    private String template;
    private final String name;
    private final List<String> subtypes;
    private final ClassLoader customizedClassLoader;
    private final Log log;

    public DocumentType(String name) {
        this.name = name;
        this.subtypes = new ArrayList<String>();
        this.customizedClassLoader = (ClassLoader)PortalGenericPortlet.CLASS_LOADER_CONTEXT.get();
        this.log = LogFactory.getLog(this.getClass());
    }

    private DocumentType(String name, Category category) {
        this(name);
        if (category != null) {
            this.folderish = category.folderish;
            this.browsable = category.folderish;
            this.navigable = category.folderish && !Category.ROOT.equals((Object)category);
            this.ordered = Category.ROOT.equals((Object)category);
            this.forceContextualization = Category.ROOT.equals((Object)category);
            this.root = Category.ROOT.equals((Object)category);
            this.file = Category.FILE.equals((Object)category);
        }
    }

    public static DocumentType createRoot(String name) {
        return new DocumentType(name, Category.ROOT);
    }

    public static DocumentType createNode(String name) {
        return new DocumentType(name, Category.NODE);
    }

    public static DocumentType createLeaf(String name) {
        return new DocumentType(name, Category.LEAF);
    }

    public static DocumentType createFile(String name) {
        return new DocumentType(name, Category.FILE);
    }

    public void addSubtypes(String ... names) {
        this.subtypes.addAll(Arrays.asList(names));
    }

    public DocumentType clone() {
        DocumentType clone = new DocumentType(this.name);
        clone.subtypes.addAll(this.subtypes);
        try {
            BeanUtils.copyProperties((Object)clone, (Object)this);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.log.error((Object)e);
        }
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentType other = (DocumentType)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DocumentType [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    public boolean isFolderish() {
        return this.folderish;
    }

    public void setFolderish(boolean folderish) {
        this.folderish = folderish;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public void setBrowsable(boolean browsable) {
        this.browsable = browsable;
    }

    public boolean isNavigable() {
        return this.navigable;
    }

    public void setNavigable(boolean navigable) {
        this.navigable = navigable;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public boolean isForceContextualization() {
        return this.forceContextualization;
    }

    public void setForceContextualization(boolean forceContextualization) {
        this.forceContextualization = forceContextualization;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public boolean isFile() {
        return this.file;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public boolean isPreventedCreation() {
        return this.preventedCreation;
    }

    public void setPreventedCreation(boolean preventedCreation) {
        this.preventedCreation = preventedCreation;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSubtypes() {
        return this.subtypes;
    }

    public ClassLoader getCustomizedClassLoader() {
        return this.customizedClassLoader;
    }

    private static enum Category {
        ROOT(true),
        NODE(true),
        LEAF(false),
        FILE(false);

        private final boolean folderish;

        private Category(boolean folderish) {
            this.folderish = folderish;
        }
    }
}

