/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms.repository.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.UpdateInformations;
import org.osivia.portal.api.cms.UpdateScope;
import org.osivia.portal.api.cms.exception.CMSException;
import org.osivia.portal.api.cms.repository.BaseUserRepository;
import org.osivia.portal.api.cms.repository.UserStorage;
import org.osivia.portal.api.cms.repository.model.RepositoryContentEvent;
import org.osivia.portal.api.cms.repository.model.RepositoryEvent;
import org.osivia.portal.api.cms.repository.model.shared.RepositoryDocument;
import org.osivia.portal.api.cms.service.CMSEvent;
import org.osivia.portal.api.cms.service.GetChildrenRequest;
import org.osivia.portal.api.cms.service.RepositoryListener;
import org.osivia.portal.api.cms.service.Request;
import org.osivia.portal.api.cms.service.SpaceCacheBean;
import org.osivia.portal.api.cms.service.StreamableRepository;
import org.osivia.portal.api.ha.IHAService;
import org.osivia.portal.api.locator.Locator;

public class SharedRepository {
    private final String repositoryName;
    private final List<RepositoryListener> listeners;
    private Map<String, RepositoryDocument> cachedDocument;
    private Map<String, SpaceCacheBean> spaceTsMap;
    private final UserStorage defaultStorage;
    public static ThreadLocal<Set<String>> requestDocs = new ThreadLocal();
    public static long DOCUMENT_RELOAD_TIMEOUT = 600000L;
    private IHAService HAService;

    public IHAService getHAService() {
        if (this.HAService == null) {
            this.HAService = (IHAService)Locator.getService(IHAService.class);
        }
        return this.HAService;
    }

    public SharedRepository(String repositoryName, UserStorage storageRepository) {
        this.repositoryName = repositoryName;
        this.listeners = new ArrayList<RepositoryListener>();
        this.cachedDocument = new Hashtable<String, RepositoryDocument>();
        this.spaceTsMap = new Hashtable<String, SpaceCacheBean>();
        this.defaultStorage = storageRepository;
    }

    private Set<String> getRequestUpdates() {
        if (requestDocs.get() == null) {
            requestDocs.set(new HashSet());
        }
        return requestDocs.get();
    }

    private void initRequestUpdates() {
        requestDocs.set(new HashSet());
    }

    public void addListener(RepositoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public void endBatch(UserStorage storageRepository) {
        storageRepository.endBatch();
    }

    public void beginBatch(UserStorage storageRepository) {
        storageRepository.beginBatch();
    }

    private CMSEvent createCMSEvent(String spaceInternalId, List<Request> dirtyRequests) throws CMSException {
        RepositoryDocument space = this.getDocument(this.defaultStorage, spaceInternalId);
        return new RepositoryContentEvent(space, dirtyRequests);
    }

    public void addDocumentToCache(String internalID, RepositoryDocument document, boolean batchMode) throws CMSException {
        this.cachedDocument.put(internalID, document);
    }

    public void removeDocumentFromCache(String internalID, boolean batchMode) throws CMSException {
        RepositoryDocument document = this.cachedDocument.get(internalID);
        if (document != null) {
            this.cachedDocument.remove(internalID);
        }
    }

    public void updateDocumentToCache(String internalID, RepositoryDocument document, boolean batchMode) throws CMSException {
        this.cachedDocument.put(internalID, document);
    }

    public RepositoryDocument getDocument(UserStorage storageRepository, String internalID) throws CMSException {
        try {
            RepositoryDocument doc = this.cachedDocument.get(internalID);
            boolean reload = false;
            if (doc != null) {
                if (!this.getRequestUpdates().contains(internalID)) {
                    SpaceCacheBean spaceTs;
                    if (doc.getSpaceId() != null && (spaceTs = this.getSpaceCacheInformations(doc.getSpaceId().getInternalID())).getLastSpaceModification() != null && doc.getTimestamp() < spaceTs.getLastSpaceModification()) {
                        reload = true;
                    }
                    if (!reload && doc.getTimestamp() + DOCUMENT_RELOAD_TIMEOUT < System.currentTimeMillis()) {
                        reload = true;
                    }
                    if (!reload && !this.getHAService().checkIfPortalParametersReloaded(doc.getTimestamp().longValue())) {
                        reload = true;
                    }
                }
            } else {
                reload = true;
            }
            if (reload) {
                this.reload(storageRepository, internalID);
                doc = this.cachedDocument.get(internalID);
                this.getRequestUpdates().add(internalID);
            }
            if (doc == null) {
                throw new CMSException();
            }
            return doc.duplicate();
        }
        catch (Exception e) {
            if (e instanceof CMSException) {
                throw (CMSException)((Object)e);
            }
            throw new CMSException(e);
        }
    }

    public void reload(UserStorage storageRepository, String internalID) throws CMSException {
        RepositoryDocument doc = storageRepository.reloadDocument(internalID);
        if (doc != null) {
            this.cachedDocument.put(internalID, doc);
        }
    }

    public void notifyUpdate(UserStorage storageRepository, UpdateInformations updateInformation) throws CMSException {
        this.applyUpdateOnNode(storageRepository, updateInformation);
        this.getHAService().notifyCMSEvent(updateInformation);
    }

    public void handleUpdate(BaseUserRepository repository, UserStorage storageRepository, UpdateInformations updateInformation) throws CMSException {
        if (repository instanceof StreamableRepository) {
            ((StreamableRepository)((Object)repository)).checkAndReload();
        } else {
            this.applyUpdateOnNode(storageRepository, updateInformation);
        }
    }

    private void applyUpdateOnNode(UserStorage storageRepository, UpdateInformations updateInformation) throws CMSException {
        SpaceCacheBean cacheBean;
        RepositoryDocument space = null;
        try {
            if (updateInformation.getSpaceID() != null) {
                space = this.getDocument(storageRepository, updateInformation.getSpaceID().getInternalID());
            }
        }
        catch (CMSException cMSException) {
            // empty catch block
        }
        RepositoryDocument document = null;
        try {
            if (updateInformation.getDocumentID() != null) {
                document = this.getDocument(storageRepository, updateInformation.getDocumentID().getInternalID());
            }
        }
        catch (CMSException cMSException) {
            // empty catch block
        }
        if (updateInformation.getDocumentID() != null) {
            this.cachedDocument.remove(updateInformation.getDocumentID().getInternalID());
        }
        if (updateInformation.getScope().equals((Object)UpdateScope.SCOPE_SPACE) && space != null) {
            Long updateTs = System.currentTimeMillis();
            if (updateInformation.isAsync()) {
                updateTs = updateTs + 10000L;
            }
            this.initRequestUpdates();
            cacheBean = this.getSpaceCacheInformations(space.getId().getInternalID());
            cacheBean.setLastSpaceModification(updateTs);
            cacheBean.setLastContentModification(updateTs);
            this.notifyChanges(this.createCMSEvent(space.getId().getInternalID(), new ArrayList<Request>()));
        }
        if (updateInformation.getScope().equals((Object)UpdateScope.SCOPE_CONTENT) && space != null && document != null) {
            ArrayList<Request> dirtyRequests = new ArrayList<Request>();
            dirtyRequests.add(new GetChildrenRequest(new UniversalID(this.repositoryName, document.getParentInternalId())));
            cacheBean = this.getSpaceCacheInformations(space.getId().getInternalID());
            cacheBean.setLastContentModification(System.currentTimeMillis());
            this.notifyChanges(this.createCMSEvent(space.getId().getInternalID(), dirtyRequests));
        }
        if (updateInformation.getScope().equals((Object)UpdateScope.SCOPE_REPOSITORY)) {
            this.notifyChanges(new RepositoryEvent());
        }
    }

    public SpaceCacheBean getSpaceCacheInformations(String spaceId) {
        SpaceCacheBean bean = this.spaceTsMap.get(spaceId);
        if (bean == null) {
            bean = new SpaceCacheBean();
            this.spaceTsMap.put(spaceId, bean);
        }
        return bean;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private void notifyChanges(CMSEvent e) {
        ArrayList<RepositoryListener> obsoleteListeners = new ArrayList<RepositoryListener>();
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.contentModified(e);
            }
            catch (NoClassDefFoundError err) {
                obsoleteListeners.add(listener);
            }
        }
        if (obsoleteListeners.size() > 0) {
            ArrayList<RepositoryListener> newListeners = new ArrayList<RepositoryListener>();
            for (RepositoryListener listener : this.listeners) {
                boolean obsolete = false;
                for (RepositoryListener obsoleteListener : obsoleteListeners) {
                    if (obsoleteListener != listener) continue;
                    obsolete = true;
                }
                if (obsolete) continue;
                newListeners.add(listener);
            }
            this.listeners.clear();
            this.listeners.addAll(newListeners);
        }
    }

    public void clear() {
        this.cachedDocument.clear();
    }
}

