/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms.repository.model.user;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.exception.CMSException;
import org.osivia.portal.api.cms.model.NavigationItem;
import org.osivia.portal.api.cms.repository.BaseUserRepository;
import org.osivia.portal.api.cms.repository.model.shared.MemoryRepositorySpace;
import org.osivia.portal.api.cms.repository.model.shared.RepositoryDocument;

public class NavigationItemImpl
implements NavigationItem {
    private RepositoryDocument document;
    private BaseUserRepository repository;

    public NavigationItemImpl(BaseUserRepository repository, RepositoryDocument document) {
        this.document = document;
        this.repository = repository;
    }

    @Override
    public UniversalID getDocumentId() {
        return this.document.getId();
    }

    @Override
    public String getTitle() {
        return this.document.getTitle();
    }

    @Override
    public NavigationItem getParent() throws CMSException {
        return new NavigationItemImpl(this.repository, this.repository.getNavigationParent(this.document));
    }

    @Override
    public List<NavigationItem> getChildren() throws CMSException {
        ArrayList<NavigationItem> children = new ArrayList<NavigationItem>();
        for (RepositoryDocument doc : this.repository.getNavigationChildren(this.document)) {
            children.add(new NavigationItemImpl(this.repository, doc));
        }
        return children;
    }

    @Override
    public boolean isRoot() {
        return this.document instanceof MemoryRepositorySpace;
    }

    @Override
    public UniversalID getSpaceId() {
        return this.document.getSpaceId();
    }

    @Override
    public UniversalID getCustomizedTemplateId() {
        return null;
    }

    @Override
    public boolean isVisible() {
        return BooleanUtils.isNotTrue((Boolean)((Boolean)this.document.getProperties().get("osivia.hidden")));
    }
}

